(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7076,        238]*)
(*NotebookOutlinePosition[     10435,        333]*)
(*  CellTagsIndexPosition[     10342,        326]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Mouse",
  " Events from ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " Display\n",
  StyleBox["\tby Konrad Polthier",
    FontSize->16]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell["\<\
When the Java panel is opened, click and drag the mouse in the middle \
display. The 2d pixel coordinates of the mouse position are interpreted by \
the handling routine below to evaluate the expression given in the bottom \
window. This example is built after the real-time algebra example in the \
J/Link manual.\
\>", "Text"],

Cell[TextData[{
  "This notebook experiments with the standard mouse listener class \
\"com.wolfram.jlink.MathMouseListener\" of J/Link. This listener operates \
synchronously and reports all mouse movements in the display to the handling \
routine in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Load Java runtime into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and initialize JavaView."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell["\<\
Create a new display in pick mode. The display is later used as 2D input \
device issuing mouse pick events. The class jv.project.PvDisplayIf is already \
preloaded inside InstallJavaView[].\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(disp = 
        viewer@newDisplay["\<JavaView: 2D Picking Area\>", \ 
            False];\)\), "\[IndentingNewLine]", 
    \(\(disp@setMajorMode[PvDisplayIf`MODEUINITIALUPICK];\)\)}], "Input",
  CellLabel->"In[3]:="],

Cell["\<\
This function will be called upon mouse pick and drag events. Here we just \
interpret the 2d mouse position in pixel coordinates of the display.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell["\<\
evalMousePosition[evt_,xa_Integer,ya_Integer,click_Integer] :=
\tJavaBlock[
\t\toutText@setText[
\t\t\tBlock[{x=N[evt@getX[]],y=N[evt@getY[]]},
\t\t\t\t\"x =\"<>ToString[x]<>\", y=\"<>ToString[y]<>\"\\n\"<>
\t\t\t\tinText@getText[]<>\"=\"<>
\t\t\t\tToString[ToExpression[inText@getText[]]]
\t\t\t]
\t\t];
\t\tReleaseObject[evt]
\t]\
\>", "Input",
  CellLabel->"In[5]:=",
  PageWidth->WindowWidth,
  ShowSpecialCharacters->False],

Cell["Register a mouse listener in the 2D-display.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell["\<\
listener = JavaNew[\"com.wolfram.jlink.MathMouseListener\"];
listener@setHandler[\"mousePressed\", \"evalMousePosition\"];
disp@addMouseListener[listener];
listener = JavaNew[\"com.wolfram.jlink.MathMouseMotionListener\"];
listener@setHandler[\"mouseDragged\", \"evalMousePosition\"];
disp@addMouseMotionListener[listener];\
\>", "Input",
  CellLabel->"In[6]:=",
  PageWidth->WindowWidth,
  ShowSpecialCharacters->False],

Cell["\<\
Show two text area components. The function in text area inText will be \
evaluated depending on the camera position, and the result displayed in \
outText.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell["\<\
inText = JavaNew[\"java.awt.TextArea\", \"Sin[x*y]\", 8, 40];
outText = JavaNew[\"java.awt.TextArea\", 8, 40];
frame = JavaNew[\"com.wolfram.jlink.MathFrame\", \"Evaluate Mouse \
Position\"];
frame@setLayout[JavaNew[\"java.awt.BorderLayout\"]];
frame@add[outText, ByRef[BorderLayout`NORTH]];
frame@add[disp, ByRef[BorderLayout`CENTER]];
frame@add[inText, ByRef[BorderLayout`SOUTH]];
frame@pack[];
frame@setBounds[200, 200, 400, 400];
frame@setModal[];
JavaShow[frame]\
\>", "Input",
  CellLabel->"In[12]:=",
  PageWidth->WindowWidth,
  ShowSpecialCharacters->False],

Cell["\<\
Share the kernel to allow further interaction with the geometry and display. \
After executing this command, start dragging inside the middle panel with the \
left mouse keeping pressed.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShareKernel[]\)], "Input",
  CellLabel->"In[23]:="],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[23]="]
}, Open  ]]
}, Open  ]],

Cell["\<\
Just test that the notebook still is available. This is in contrast to the \
usage of RunJavaView[] which may block execution of.the notebook.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(viewer@\(getDisplay[]@getName[]\)\)], "Input",
  CellLabel->"(sharing) In[24]:="],

Cell[BoxData[
    \("JavaView: 2D Picking Area"\)], "Output",
  CellLabel->"Out[24]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Or get in modal mode and pick/drag in JavaView window. But this command \
blocks further execution of this notebook until JavaView has exited. \
Therefore, we prefer ShareKernel[].\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(DoModal[]\)], "Input",
  CellLabel->"In[27]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Clear ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from all Java processes. After calling UninstallJava[] the package \
<<JavaView`JLink` must be loaded again."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(UninstallJava[];\)\)], "Input",
  CellLabel->"(sharing) In[24]:="]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 723}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{801, 686},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, \
56.6875}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.1.3"->{
    Cell[2699, 82, 176, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3006, 95, 252, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3503, 109, 207, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4154, 132, 98, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4688, 147, 218, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5487, 172, 248, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5921, 191, 204, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6377, 210, 242, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6726, 224, 243, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]},
  "3.5"->{
    Cell[2699, 82, 176, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3006, 95, 252, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3503, 109, 207, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4154, 132, 98, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4688, 147, 218, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5487, 172, 248, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5921, 191, 204, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6377, 210, 242, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6726, 224, 243, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.1.3", 8816, 284},
  {"3.5", 9572, 303}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 289, 11, 98, "Chapter",
  CellGroupingRules->"SectionGrouping"],
Cell[2009, 62, 338, 6, 67, "Text"],
Cell[2350, 70, 324, 8, 48, "Text"],

Cell[CellGroupData[{
Cell[2699, 82, 176, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[2878, 90, 125, 3, 54, "Input"],
Cell[3006, 95, 252, 5, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3261, 102, 239, 5, 54, "Input"],
Cell[3503, 109, 207, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3713, 115, 438, 15, 266, "Input"],
Cell[4154, 132, 98, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4255, 135, 430, 10, 151, "Input"],
Cell[4688, 147, 218, 5, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4909, 154, 575, 16, 266, "Input"],
Cell[5487, 172, 248, 5, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[5760, 181, 71, 2, 33, "Input"],
Cell[5834, 185, 60, 2, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[5921, 191, 204, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[6150, 199, 101, 2, 50, "Input"],
Cell[6254, 203, 86, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6377, 210, 242, 5, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[6622, 217, 67, 2, 33, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6726, 224, 243, 7, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[6972, 233, 88, 2, 50, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

