(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8746,        290]*)
(*NotebookOutlinePosition[     12515,        394]*)
(*  CellTagsIndexPosition[     12420,        387]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Timer Events from ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  "\n",
  StyleBox["\tby Konrad Polthier",
    FontSize->16]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[TextData[{
  "In this notebook ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " catches timer events issued from the JavaView animation class to \
recompute the position of a satellite orbiting around a torus."
}], "Text"],

Cell[TextData[{
  "To check performance of the event handling we provide two alternative \
methods to let the satellite move.\n1. A simple loop in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is used to trigger the event handling routine directly without any event \
handling in between.\n2. The standard event handling mechanism. The animation \
may be started either by button press in animation panel of JavaView, or in \
share-kernel mode by issueing a command from this notebook. See below."
}], "Text"],

Cell["\<\
Usage: First execute the upper command group with the outer bracket. Then \
scroll down the notebook and execute the commands following the upper outer \
bracket successively.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Load Java runtime into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and load JavaView."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell["Create an empty geometry to become the world.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\(\ \)\)\)], "Input",
  CellLabel->"In[3]:="],

Cell["\<\
Compute a sample torus geometry and register it inside the display.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(innerRadius\  = 2. ;\)\), "\[IndentingNewLine]", 
    \(\(tubeRadius = 1. ;\)\), "\[IndentingNewLine]", 
    \(\(geom@
        computeTorus[20, 15, innerRadius, 
          tubeRadius];\)\), "\[IndentingNewLine]", 
    \(\(geom@setName["\<Torus World\>"];\)\), "\[IndentingNewLine]", 
    \(\(JavaView[geom];\)\)}], "Input",
  CellLabel->"In[4]:="],

Cell["\<\
Get the active JavaView 3d-display to be able to register the satellite \
additionally to the torus geometry.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(disp = viewer@getDisplay[];\)\)], "Input",
  CellLabel->"In[9]:="],

Cell["Create another empty geometry to become a satellite.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(sat\  = \ JavaNew["\<jv.geom.PgElementSet\>"];\)\)], "Input",
  CellLabel->"In[10]:="],

Cell["Compute the satellite and register it inside the display.", \
"MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(LoadClass["\<jvx.geom.PwPlatonic\>"];\)\), "\[IndentingNewLine]", 
    \(\(PwPlatonic`setSolid[sat, 
        PwPlatonic`DODECAHEDRON];\)\), "\[IndentingNewLine]", 
    \(\(sat@setName["\<Satellite\>"];\)\), "\[IndentingNewLine]", 
    \(sat@
      setGlobalElementColor[
        JavaNew["\<java.awt.Color\>", \ 255, 150, 
          0]]\), "\[IndentingNewLine]", 
    \(\(sat@
        scale[1. /5. , \ 
          JavaNew["\<jv.vecmath.PdVector\>", 
            3]];\)\), "\[IndentingNewLine]", 
    \(\(sat@showVertexNormals[True];\)\), "\[IndentingNewLine]", 
    \(\(disp@addGeometry[sat];\)\), "\[IndentingNewLine]", 
    \(\(sat@update[sat];\)\)}], "Input",
  CellLabel->"In[11]:="],

Cell["\<\
Event handler command invoked from JavaView upon timer events. This method \
calls setTime[time] to do the work.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell["\<\
setTime[evt_,message_] :=
\tJavaBlock[
\t\tsetTime[N[evt]];
\t\tReleaseObject[evt]
\t]
\t
(* Keep this variable outside to avoid frequent allocations. *)
center = JavaNew[\"jv.vecmath.PdVector\",3];
(* Initial number of time steps per flight. (Pending) Should be overwritten \
by settings in the animation panel. *)
numTics = 100;
(* This function will be called upon timer events, or it may be invoked \
directly from Mathematica, see below. *)
setTime[time_] :=
\tJavaBlock[
\t\tir = innerRadius;
\t\ttr = tubeRadius;
\t\theight = tubeRadius/3.; (* Height of Satellite over Torus. *)
\t\tnumUWindings = 1;
\t\tnumZWindings = 13;
\t\tu = time*2.*Pi*numUWindings/(numTics-1.);
\t\tv = time*2.*Pi*numZWindings/(numTics-1.);
\t\tcenter@set[
\t\t\tN[Cos[u]*((tr+tubeRadius/3.)*Cos[v]+ir)],
\t\t\tN[Sin[u]*((tr+tubeRadius/3.)*Cos[v]+ir)],
\t\t\tN[(tr+tubeRadius/3.)*Sin[v]]];
\t\tPwPlatonic`setSolid[sat,PwPlatonic`DODECAHEDRON];
\t\tsat@scale[1./5.];
\t\tsat@translate[center];
\t\tsat@update[Null];
\t]\
\>", "Input",
  CellLabel->"In[19]:=",
  PageWidth->WindowWidth,
  ShowSpecialCharacters->False],

Cell[TextData[{
  "The animation panel often appears behind the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook and must be brought to font manually."
}], "Text"],

Cell["Register a listener of timer events.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(listener = 
        JavaNew["\<jvx.math.MathTimerListener\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(listener@
        setHandler["\<setTime\>", "\<setTime\>"];\)\), "\[IndentingNewLine]", \

    \(\(anim\  = \ 
        JavaNew["\<jv.anim.PsAnimation\>"];\)\), "\[IndentingNewLine]", 
    \(\(anim@setName["\<Satellite Animation\>"];\)\), "\[IndentingNewLine]", 
    \(\(anim@addTimeListener[listener];\)\), "\[IndentingNewLine]", 
    \(\(JavaShow[anim@getAnimationPanel[]];\)\)}], "Input",
  CellLabel->"In[27]:="],

Cell["\<\
Share the kernel to allow further interaction with the geometry and \
display.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShareKernel[]\)], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[33]="]
}, Open  ]],

Cell["\<\
When sharing the kernel we can control the animation from this notebook.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(anim@start[]\)], "Input",
  CellLabel->"(sharing) In[34]:="]
}, Open  ]],

Cell[BoxData[
    \(anim@stop[]\)], "Input",
  CellLabel->"(sharing) In[48]:="],

Cell[CellGroupData[{

Cell["\<\
It is also possible to use a direct invocation of the event handler from a \
Mathematica loop.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(For[i = 0. , i < numTics, \(i++\), setTime[i]]\)], "Input",
  CellLabel->"In[34]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Clear ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from all Java processes. After calling UninstallJava[] the package \
<<JavaView`JLink` must be loaded again."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(UninstallJava[];\)\)], "Input",
  CellLabel->"(sharing) In[43]:="]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 723}},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{802, 692},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, \
56.6875}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.1.3"->{
    Cell[2984, 88, 170, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3285, 101, 99, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3520, 109, 129, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4025, 124, 171, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4290, 134, 106, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4510, 141, 113, 2, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5337, 163, 174, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6810, 213, 90, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7446, 230, 140, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7760, 247, 134, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8096, 263, 156, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8396, 276, 243, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]},
  "3.5"->{
    Cell[2984, 88, 170, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3285, 101, 99, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3520, 109, 129, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4025, 124, 171, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4290, 134, 106, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4510, 141, 113, 2, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5337, 163, 174, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6810, 213, 90, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7446, 230, 140, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7760, 247, 134, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8096, 263, 156, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8396, 276, 243, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.1.3", 10396, 333},
  {"3.5", 11401, 358}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 275, 10, 98, "Chapter",
  CellGroupingRules->"SectionGrouping"],
Cell[1995, 61, 237, 6, 48, "Text"],
Cell[2235, 69, 522, 9, 102, "Text"],
Cell[2760, 80, 199, 4, 48, "Text"],

Cell[CellGroupData[{
Cell[2984, 88, 170, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3157, 96, 125, 3, 54, "Input"],
Cell[3285, 101, 99, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3387, 104, 130, 3, 33, "Input"],
Cell[3520, 109, 129, 3, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3652, 114, 370, 8, 117, "Input"],
Cell[4025, 124, 171, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4199, 130, 88, 2, 33, "Input"],
Cell[4290, 134, 106, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4399, 137, 108, 2, 33, "Input"],
Cell[4510, 141, 113, 2, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4626, 145, 708, 16, 180, "Input"],
Cell[5337, 163, 174, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[5514, 169, 1108, 35, 726, "Input"],
Cell[6625, 206, 182, 5, 29, "Text"],
Cell[6810, 213, 90, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[6903, 216, 540, 12, 138, "Input"],
Cell[7446, 230, 140, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[7611, 238, 71, 2, 33, "Input"],
Cell[7685, 242, 60, 2, 27, "Output"]
}, Open  ]],
Cell[7760, 247, 134, 3, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[7897, 252, 80, 2, 50, "Input"]
}, Open  ]],
Cell[7992, 257, 79, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[8096, 263, 156, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[8255, 269, 104, 2, 33, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8396, 276, 243, 7, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[8642, 285, 88, 2, 50, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

