package vgp.tutor.firstApplet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;

import jv.geom.PgElementSet;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;

/**
 * Demo applet showing how to include JavaView display in own code.
 * 
 * @see			jv.viewer.PvViewer
 * @author		Konrad Polthier
 * @version		25.12.99, 1.10 revised (kp) Geometry is added directly to display rather than to default project.<br>
 *					04.08.99, 1.00 created (kp)
 */
public class main extends Applet {
	/**
	 * Applet support. Configure and initialize the viewer,
	 * load geometry and add display.
	 */
	public void init() {
		// Create viewer for viewing 3d geometries, and register applet.
		PvViewer viewer = new PvViewer(this, null);

		// Create a simple geometry
		PgElementSet geom = new PgElementSet(3);
		geom.setName("Torus");
		// Compute coordinates and mesh of a geometry
		geom.computeTorus(10, 10, 2., 1.);

		// Get default display from viewer
		PvDisplayIf disp = viewer.getDisplay();
		// Register geometry in display, and make it active.
		// For more advanced applications it is advisable to create a separate project
		// and register geometries in the project via project.addGeometry(geom) calls.
		disp.addGeometry(geom);
		disp.selectGeometry(geom);

		// Add display to applet
		setLayout(new BorderLayout());
		add("Center", (Component)disp);
		validate();
		
		// Start viewer, e.g. to read parameters from Html page (only purpose here)
		viewer.start();
	}
}
