package vgp.tutor.transform;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

/**
 * Info panel of space form transformations with sliders.
 * 
 * @author		Konrad Polthier
 * @version		25.12.99, 1.00 revised (kp) <br>
 *					25.12.99, 1.00 created (kp)
 */
public class PjTransform_IP extends PjProject_IP implements ActionListener {
	protected	PjTransform				m_pjTransform;
	protected	PsPanel					m_pBounds;
	protected	Button					m_bReset;

	public PjTransform_IP() {
		super();
		if (getClass() == PjTransform_IP.class)
			init();
	}
	public void init() {
		super.init();
		addTitle("");

		// draw a separator
		addLine(1);

		m_pBounds = new PsPanel();
		addSubTitle("Rotation Angles");
		m_pBounds.setLayout(new GridLayout(3, 1));
		add(m_pBounds);

		// draw a separator
		addLine(1);

		// buttons at bottom
		Panel m_pBottomButtons = new Panel();
		m_pBottomButtons.setLayout(new FlowLayout(FlowLayout.CENTER));
		add(m_pBottomButtons);
		m_bReset = new Button("Reset");
		m_bReset.addActionListener(this);
		m_pBottomButtons.add(m_bReset);
	}
	public void start() {
		
	}
	/**
	 * Set parent of panel which supplies the data inspected by the panel.
	 */
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);
		m_pjTransform = (PjTransform)parent;
		m_pBounds.add(m_pjTransform.m_angleXW.getInfoPanel());
		m_pBounds.add(m_pjTransform.m_angleYW.getInfoPanel());
		m_pBounds.add(m_pjTransform.m_angleZW.getInfoPanel());
	}
	/**
	 * Update the panel whenever the parent has changed somewhere else.
	 * Method is invoked from the parent or its superclasses.
	 */
	public boolean update(Object event) {
		if (PsDebug.NOTIFY) PsDebug.notify("PjTransform_IP.update: isShowing = "+isShowing());
		if (m_pjTransform == event) {
			setTitle(m_pjTransform.getName());
			return true;
		}
		return super.update(event);
	}
	/**
	 * Handle action events invoked from buttons, menu items, text fields.
	 */
	public void actionPerformed(ActionEvent event) {
		if (m_pjTransform==null)
			return;
		Object source = event.getSource();
		if (source == m_bReset) {
			m_pjTransform.init();
			m_pjTransform.m_surface.update(m_pjTransform.m_surface);
			m_pjTransform.m_base.update(m_pjTransform.m_base);
		}
	}
}

