// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   C u s t o m D i a l o g
//

public class CustomDialog extends Dialog {


//
//   v a r i a b l e s
//

private Custom m_custom;
private boolean m_active;
private Rectangle m_bounds;

private Portfolio m_portfolio;


//
//   C u s t o m D i a l o g
//

public CustomDialog( Portfolio portfolio )

{
	super( Pool.m_frame, "Customized Option", false );

    m_portfolio = portfolio;

	setResizable( false );

    GridBagLayout layout = new GridBagLayout();
    setLayout( layout );

    GridBagConstraints c = new GridBagConstraints();
    c.anchor = GridBagConstraints.NORTHWEST;
    c.insets = new Insets( 15, 15, 15, 15 );

    m_custom = new Custom();

    add( m_custom );
    layout.setConstraints( m_custom, c );

    if( Pool.m_bgColor != null )
        setBackground( Pool.m_bgColor );

    m_active = true;

	pack();
}


//
//   a t t a c h
//

public void attach( Portfolio portfolio )

{
    m_portfolio = portfolio;
    if( m_active ) {
        m_custom.clear();
        m_custom.disable();
    }
}


//
//   b o u n d s
//

public Rectangle bounds()

{
    if( m_bounds == null )
        m_bounds = super.bounds();
    return m_bounds;
}


//
//   c u s t o m
//

public Custom custom()

{
    return m_custom;
}


//
//   i s A c t i v e
//

public boolean isActive()

{
    return m_active;
}


//
//   d e a c t i v a t e
//

public void deactivate()

{
    if( m_active ) {
        m_portfolio.customDlgAlert();
        hide();
		dispose();
        m_active = false;
    }
}


//
//   h a n d l e E v e n t
//

public boolean handleEvent( Event evt )

{
    switch( evt.id ) {
	    case Event.WINDOW_DESTROY:
            deactivate();
            return true;

	    case Event.WINDOW_MOVED:
            m_bounds = super.bounds();
            return true;

        default:
            return super.handleEvent( evt );
    }			 
}


//
//   a c t i o n
//

public boolean action( Event evt, Object obj )

{
	return false;
}

} // end of class
