// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   D i s c l a i m e r
//

public class Disclaimer extends Dialog {


//
//   v a r i a b l e s
//

private Button m_buAgree;
private Button m_buDontAgree;
private TextArea m_taText;

private boolean m_agree = false;

private String m_disclaimer =
    "This software is part of the Mtg-Book package and distributed under the\n" +
    "GNU public license. See the documentation on the CD-ROM for information,\n" +
    "or contact the original author at http://robertbuff.com/uvm.";

//
//   D i s c l a i m e r
//

public Disclaimer()

{
	super( Pool.m_frame, "Disclaimer", true );

	setResizable( false );

    m_taText = new TextArea( m_disclaimer, 16, 80  );
    m_taText.setEditable( false );
	m_buAgree = new Button( " I agree " );
	m_buDontAgree = new Button( " I don't agree " );

	setLayout( new BorderLayout() );

	Panel p = new Panel();
	p.setLayout( new FlowLayout( FlowLayout.CENTER, 15, 15 ) );

	add( "Center", m_taText );
	p.add( m_buAgree );
	p.add( m_buDontAgree );
	add( "South", p );

	pack();
}


//
//   h a n d l e E v e n t
//

public boolean handleEvent( Event evt )

{
    switch( evt.id ) {
	    case Event.WINDOW_DESTROY:
            hide();
		    dispose();
            return true;

        default:
            return super.handleEvent( evt );
    }			 
}


//
//   a c t i o n
//

public boolean action( Event evt, Object obj )

{
    if( evt.target == m_buAgree || evt.target == m_buDontAgree ) {
        if( evt.target == m_buAgree )
            m_agree = true;
        hide();
	    dispose();
	    return true;
	}

	return false;
}


//
//   a g r e e
//

public boolean agree()

{
    return m_agree;
}

} // end of class
