// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   F i r e w a l l D i a l o g
//

public class FirewallDialog extends Dialog {


//
//   v a r i a b l e s
//

private ExtButton m_buOK;
private ExtButton m_buCancel;
private ExtCheckbox m_cbUseProxy;
private ExtTextField m_tfHost;
private ExtTextField m_tfPort;


//
//   F i r e w a l l D i a l o g
//

public FirewallDialog()

{
	super( Pool.m_frame, "Firewall", true );

	setResizable( false );

	setLayout( new BorderLayout() );

    Panel row1 = new Panel();
    Panel row2 = new Panel();
    Panel row3 = new Panel();

    GridBagLayout grid1 = new GridBagLayout();
    GridBagLayout grid2 = new GridBagLayout();
    GridBagLayout grid3 = new GridBagLayout();

    GridBagConstraints c = new GridBagConstraints();
    c.anchor = GridBagConstraints.WEST;
    c.gridy = 0;

    row1.setLayout( grid1 );
    row2.setLayout( grid2 );
    row3.setLayout( grid3 );

    m_cbUseProxy = new ExtCheckbox( 0, "Use proxy server" );
    m_tfHost = new ExtTextField( 0, 20 );
    m_tfPort = new ExtTextField( 0, 6 );
	m_buOK = new ExtButton( Id.OK, "Ok", "   Cancel   " );
	m_buCancel = new ExtButton( Id.CANCEL, "Cancel", "   Cancel   " );

    m_tfHost.setText( Pool.m_proxyHost );
    m_tfPort.setText( Integer.toString( Pool.m_proxyPort ) );
    m_cbUseProxy.setState( Pool.m_useProxy );
    if( ! Pool.m_useProxy ) {
        m_tfHost.disable();
        m_tfPort.disable();
    }

    Label lab1 = new Label( "HTTP://" );
    Label lab2 = new Label( ":" );

    c.weightx = 1;
    c.insets = new Insets( 10, 10, 0, 10 );
    row1.add( m_cbUseProxy );
    grid1.setConstraints( m_cbUseProxy, c );
    c.weightx = 0;
    c.insets = new Insets( 10, 10, 0, 0 );
    row2.add( lab1 );
    grid2.setConstraints( lab1, c );
    c.insets = new Insets( 10, 0, 0, 0 );
    row2.add( m_tfHost );
    grid2.setConstraints( m_tfHost, c );
    c.weightx = 1;
    row2.add( lab2 );
    grid2.setConstraints( lab2, c );
    c.insets = new Insets( 10, 0, 0, 10 );
    row2.add( m_tfPort );
    grid2.setConstraints( m_tfPort, c );
    c.weightx = 0;
    c.insets = new Insets( 10, 10, 10, 10 );
    row3.add( m_buOK );
    grid3.setConstraints( m_buOK, c );
    row3.add( m_buCancel );
    grid3.setConstraints( m_buCancel, c );

	add( "North", row1 );
	add( "Center", row2 );
	add( "South", row3 );

	pack();
}


//
//   h a n d l e E v e n t
//

public boolean handleEvent( Event evt )

{
    switch( evt.id ) {
	    case Event.WINDOW_DESTROY:
            hide();
		    dispose();
            return true;

        default:
            return super.handleEvent( evt );
    }			 
}


//
//   a c t i o n
//

public boolean action( Event evt, Object obj )

{
    if( evt.target == m_buOK )
        return ok();
	
    if( evt.target == m_buCancel ) {
        hide();
        dispose();
        return true;
    }

    if( evt.target == m_cbUseProxy ) {
        if( m_cbUseProxy.getState() ) {
            m_tfHost.enable();
            m_tfPort.enable();
        }
        else {
            m_tfHost.setBackground( null );
            m_tfPort.setBackground( null );
            m_tfHost.disable();
            m_tfPort.disable();
        }

        return true;
    }

	return false;
}


//
//   o k
//

private boolean ok()

{
    if( m_cbUseProxy.getState() ) {
        int port = 8080;

        if( ! m_tfHost.hasValue() ) {
            m_tfHost.setBackground( Color.red );
            m_tfHost.requestFocus();
            return true;
        }
        else {
            m_tfHost.setBackground( null );
        }

        if( m_tfPort.hasValue() ) {
            try {
                m_tfPort.setBackground( Color.red );
                port = m_tfPort.getPosInt();
            }
            catch( DataException e ) {
                m_tfPort.requestFocus();
                return true;
            }
        }
        else {
            m_tfPort.setBackground( null );
        }

        Pool.m_proxyHost = m_tfHost.getText().trim();
        Pool.m_proxyPort = port;

        SecurityManager sm = System.getSecurityManager();

        try {
            sm.checkConnect( Pool.m_proxyHost, Pool.m_proxyPort );
        }
        catch( SecurityException e ) {
            MessageBox.ok( Pool.m_frame, "Error",
                "I'm not allowed to access this proxy" );
            return true;
        }
    }

    Pool.m_useProxy = m_cbUseProxy.getState();

    hide();
	dispose();

	return true;
}

} // end of class
