// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;
import java.applet.*;


///////////////////////////////////////////////////////////////////
//
//   M a i n F r a m e
//

public class MainFrame extends Frame {


//
//   v a r i a b l e s
//

private MtgClt m_applet;
private MainMenu m_mainMenu;
private Evaluater m_evaluater;

private boolean m_agree = false;


//
//   M a i n F r a m e
//

public MainFrame( MtgClt applet, String serverHost, String serverPort,
    String homeUrl, String tutorialPath )

{
    super( Pool.m_title );

    m_applet = applet;
    m_mainMenu = new MainMenu();

    setMenuBar( m_mainMenu );

    Pool.init( this, m_mainMenu, applet == null, serverHost, serverPort,
        homeUrl, tutorialPath );

    GridBagLayout layout = new GridBagLayout();
    setLayout( layout );

    GridBagConstraints c = new GridBagConstraints();

    c.fill = GridBagConstraints.BOTH;
    c.gridx = 0;
    c.weightx = 1;
    c.weighty = 0;
    layout.setConstraints( Pool.m_toolbar, c );
    add( Pool.m_toolbar );
    c.weighty = 1;
    Panel p = createClientArea();
    layout.setConstraints( p, c );
    add( p );
    c.weighty = 0;
    layout.setConstraints( Pool.m_status, c );
    add( Pool.m_status );

    pack();
}


//
//   h a n d l e E v e n t
//

public boolean handleEvent( Event evt )

{
    switch( evt.id ) {
        case Event.WINDOW_DESTROY:
            quit();
            return true;

        default:
            return super.handleEvent( evt );
    }			 
}


//
//   a c t i o n
//

public boolean action( Event evt, Object what )

{
    int cmd = m_mainMenu.command( evt );

    switch( cmd ) {
        case Id.NEW :        Pool.m_workSpace.clear();     break;
        case Id.SAVE :       Pool.m_report.save();         break;
        case Id.SAVE_AS :    Pool.m_report.saveAs();       break;
        case Id.RESET :      Pool.m_workSpace.reset();     break;
        case Id.COPY_TO :    Pool.m_report.copyTo();       break;
        case Id.SELECT_ALL : Pool.m_report.selectAll();    break;
        case Id.EXIT :       quit();                       break;
        case Id.START :      startExec();                  break;
        case Id.STOP :       stopExec();                   break;
        case Id.FIREWALL :   firewall();                   break;
        case Id.PORTFOLIO :  Pool.m_workSpace.portfolio(); break;
        case Id.SCENARIO :   Pool.m_workSpace.scenario();  break;
        case Id.ADVANCED :   Pool.m_workSpace.advanced();  break;
        case Id.ONECLICK :   Pool.m_workSpace.oneClick();  break;
        case Id.TUTORIAL :   tutorial();                   break;
        case Id.ABOUT :      about();                      break;

        default : 
            if( cmd >= Id.EXAMPLE1 && cmd <= Id.EXAMPLE9 ) {
                Pool.m_workSpace.example( cmd - Id.EXAMPLE1 + 1 );
                break;
            }                
            return false;
    }

    return true;
}


//
//   c r e a t e C l i e n t A r e a
//

private Panel createClientArea()

{
    MosaicPanel panel = new MosaicPanel();
    MosaicLayout layout = new MosaicLayout();

    panel.setLayout( layout );

    layout.setConstraints( "1", new MosaicConstraints(
        MosaicConstraints.NORTHWEST, MosaicConstraints.BOTH, 3, 0 ) );
    layout.setConstraints( "2", new MosaicConstraints(
        MosaicConstraints.NORTHWEST, MosaicConstraints.BOTH, 2, 1 ) );
    layout.setConstraints( "3", new MosaicConstraints(
        MosaicConstraints.NORTHWEST, MosaicConstraints.BOTH, 1, 1 ) );

    layout.setPos( 0, 0 );
    panel.add( "1", Pool.m_workSpace );
    layout.setPos( 0, 1, 0, 0 );
    panel.add( "2", Pool.m_report );
    layout.setPos( 0, 1, 1, 0 );
    panel.add( "3", Pool.m_resultGraph );

    return panel;
}


//
//   q u i t
//

private void quit()

{
    hide();
	dispose();

	if( Pool.m_standAlone )
	    System.exit( 0 );
    else
        if( m_applet != null )
            m_applet.quit();
}


//
//   s t a r t E x e c
//

private void startExec()

{
    if( ! m_agree ) {
        Disclaimer disc = new Disclaimer();
        disc.show();
        if( disc.agree() )
            m_agree = true;
        else
            return;
    }

    if( m_evaluater == null || ! m_evaluater.isAlive() ) {
        m_evaluater = new Evaluater();
        m_evaluater.startExec();    
    }
}


//
//   s t o p E x e c
//

private void stopExec()

{
    if( m_evaluater.isAlive() )
        m_evaluater.stopExec();
}


//
//   f i r e w a l l
//

private void firewall()

{
    FirewallDialog fire = new FirewallDialog();
    fire.show();
}


//
//   t u t o r i a l
//

private void tutorial()

{
    if( m_applet != null ) {        
        AppletContext ctx = m_applet.getAppletContext();

        if( ctx == null ) {
            return;
        }

        ctx.showDocument( Pool.m_tutorialUrl, "MtgTutorial" );
    }
}


//
//   a b o u t
//

private void about()

{
    AboutDialog about = new AboutDialog();
    about.show();
}

} // end of class


