// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   O n e C l i c k
//

public class OneClick extends ParamSpace {

    // the following variables are for the GUI        

private Portfolio m_portfolio;
private Scenario m_scenario;
private Advanced m_advanced;


//
//   O n e C l i c k
//

public OneClick()

{
    super( Id.ONECLICK );

    m_portfolio = new Portfolio( true );
    m_scenario = new Scenario( true );
    m_advanced = new Advanced( true );

    GridBagLayout layout = new GridBagLayout();
    setLayout( layout );

    GridBagConstraints c = new GridBagConstraints();

    c.anchor = GridBagConstraints.NORTHWEST;
    c.gridx = 0;
    c.gridwidth = 2;
    add( m_portfolio, c );
    c.gridy = 1;
    c.gridwidth = 1;
    c.insets = new Insets( 20, 0, 0, 0 );
    add( m_scenario, c );
    c.gridx = 1;
    c.insets = new Insets( 20, 0, 0, 0 );
    add( m_advanced, c );

    if( Pool.m_bgColor != null )
        setBackground( Pool.m_bgColor );

    m_examples = m_portfolio.borrowExamples();

    clear();                    
}


//
//   c l e a r 
//

public void clear()

{
    m_portfolio.clear();
    m_scenario.clear();
    m_advanced.clear();
}


//
//   d e t a c h
//

public void detach()

{
    m_portfolio.detach();
    m_scenario.detach();
    m_advanced.detach();
}


//
//   e x a m p l e
//

public void example( int num )

{
    m_portfolio.example( num );
}


//
//   p r e p a r e
//

public void prepare()
    throws DataException

{
    m_portfolio.clearWrong();
    m_scenario.clearWrong();
    m_advanced.clearWrong();

    try {
        m_portfolio.prepare();
    }
    catch( DataException e ) {
        m_portfolio.showWrong();
        throw e;
    }

    try {
        m_scenario.prepare( m_portfolio );
    }
    catch( DataException e ) {
        m_scenario.showWrong();
        throw e;
    }

    try {
        m_advanced.prepare( m_portfolio, m_scenario );
    }
    catch( DataException e ) {
        m_advanced.showWrong();
        throw e;
    }
}


//
//   p r o t O n e C l i c k
//

public String protOneClick()

{
    return m_scenario.protScenario( m_advanced ) + 
           m_portfolio.protPortfolio() +
           m_advanced.protAdvanced( m_scenario );
}


//
//   p a r a m T i m e s t e p
//

public int[] paramTimestep()

{
    return m_advanced.paramTimestep();
}


//
//   p a r a m S e l l e r
//

public boolean paramSeller()

{
    return m_scenario.paramSeller();
}


//
//   p a r a m B u y e r
//

public boolean paramBuyer()

{
    return m_scenario.paramBuyer();
}


//
//   p a r a m I s U n c e r t a i n
//

public boolean paramIsUncertain()

{
    return m_scenario.paramIsUncertain();
}


//
//   p a r a m S p o t P r i c e
//

public double paramSpotPrice()

{
    return m_scenario.paramSpotPrice();
}


//
//   c o p y T o
//

public void copyTo( Portfolio portfolio, Scenario scenario, Advanced advanced )

{
    portfolio.copyFrom( m_portfolio );
    scenario.copyFrom( m_scenario );
    advanced.copyFrom( m_advanced );
}


//
//   c o p y F r o m
//

public void copyFrom( Portfolio portfolio, Scenario scenario, Advanced advanced )

{
    m_portfolio.copyFrom( portfolio );
    m_scenario.copyFrom( scenario );
    m_advanced.copyFrom( advanced );
}

} // end of class
