// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   P o r t f o l i o
//

public class Portfolio extends ParamSpace {


//
//   v a r i a b l e s
//

    // the following variables are for the GUI        

private boolean m_oneClick;

private int m_numOfClaims;

private boolean m_active[];
private Claim m_claim[];

private CustomDialog m_dlgCustom;
private Rectangle m_customBounds;

private int m_lastFocused;
private int m_lastLinked;

private String[] m_myExamples = {
    "We're long a vanilla call with strike price 105, maturing in 60 days",
    "A portfolio: long the same call, short 2 vanilla put contracts",
    "Instead of erasing the values, simply deactivate the entire row",
    "Adding a single up-and-out barrier call to the portfolio",
    "A single and a double barrier option - the latter is American",
    "Three customized instruments demonstrate the scripting language"
};

    // these are the parameters for the calculation

private int m_paramMaturity;    // of entire portfolio


//
//   P o r t f o l i o
//

public Portfolio()

{
    this( false );
}


//
//   P o r t f o l i o
//

public Portfolio( boolean oneClick )

{
    super( Id.PORTFOLIO );

    m_oneClick = oneClick;

    if( m_oneClick )
        m_numOfClaims = 3;
    else
        m_numOfClaims = 8;

    m_active = new boolean[m_numOfClaims];
    m_claim = new Claim[m_numOfClaims];

    GridBagLayout layout = new GridBagLayout();
    setLayout( layout );

    GridBagConstraints c = new GridBagConstraints();

    c.anchor = GridBagConstraints.NORTHWEST;
    c.gridx = 0;
    add( createTable1(), c );

    if( Pool.m_bgColor != null )
        setBackground( Pool.m_bgColor );

    m_examples = m_myExamples;

    clear();                    
}


//
//   c l e a r
//

public void clear()

{
    clearWrong();

    for( int k = 0; k < m_numOfClaims; ++k )
        m_claim[k].clear();

    if( m_dlgCustom != null ) {
        if( m_dlgCustom.isActive() )
            m_dlgCustom.custom().clear();
        else
            m_dlgCustom = null;
    }

    m_lastFocused = -1;
    m_lastLinked = -1;
}


//
//   e x a m p l e
//

public void example( int num )

{
    clear();

    switch( num ) {
        case 1 :
            m_claim[0].setExample( 0 );
            break;

        case 2 :
            m_claim[0].setExample( 0 );
            m_claim[1].setExample( 1 );
            break;

        case 3 :
            m_claim[0].setExample( 0 );
            m_claim[1].setExample( 2 );
            break;

        case 4 :
            m_claim[0].setExample( 0 );
            m_claim[1].setExample( 2 );
            m_claim[2].setExample( 3 );
            break;

        case 5 :
            m_claim[0].setExample( 3 );
            m_claim[1].setExample( 4 );
            break;

        case 6 :
            m_claim[0].setExample( 5 );
            m_claim[1].setExample( 6 );
            m_claim[2].setExample( 7 );
            m_claim[1].adjust();
            m_claim[2].adjust();
            m_claim[0].adjust( getCustom( true ) );
            m_lastFocused = 0;
            m_lastLinked = 0;
            break;
    }
}


//
//   a c t i o n
//

public boolean action( Event evt, Object what )

{
    if( evt.target instanceof ExtCheckbox ) {
        int id = ( (ExtCheckbox) evt.target ).id();
        if( id >= 0 && id < m_numOfClaims ) {
            if( ! m_claim[id].adjust( getCustom( false ) ) )
                m_claim[id].adjust( getCustom( true ) );
        }
    }
    else
    if( evt.target instanceof ExtChoice ) {
        int id = ( (ExtChoice) evt.target ).id();
        if( id >= 0 && id < m_numOfClaims ) {
            if( ! m_claim[id].adjust( getCustom( false ) ) )
                m_claim[id].adjust( getCustom( true ) );
        }
    }

    return false;
}


//
//   g o t F o c u s
//

public boolean gotFocus( Event evt, Object what )

{
    int id = -1;

    if( evt.target instanceof ExtCheckbox ) {
        id = ( (ExtCheckbox) evt.target ).id();
    }
    else
    if( evt.target instanceof ExtChoice ) {
        id = ( (ExtChoice) evt.target ).id();
    }
    else
    if( evt.target instanceof ExtTextField ) {
        id = ( (ExtTextField) evt.target ).id();
    }

    if( id >= 0 && id < m_numOfClaims ) {
        if( id != m_lastLinked ) {
            if( m_lastLinked >= 0 )
                m_claim[m_lastLinked].retrieveCustom( getCustom( false ) );
            m_lastLinked = id;
        }
        if( id != m_lastFocused ) {
            if( ! m_claim[id].adjustCustom( getCustom( false ) ) )
                m_claim[id].adjustCustom( getCustom( true ) );
            m_lastFocused = id;
        }              
    }
    else {
        m_lastFocused = -1;
    }

    return true;
}


//
//   p r e p a r e
//

public void prepare()
    throws DataException

{
    clearWrong();

    m_paramMaturity = 0;

    for( int k = 0; k < m_numOfClaims; ++k ) {
        m_active[k] = m_claim[k].isActive();
        if( m_active[k] ) {
            try {
                if( k == m_lastLinked )
                    m_claim[k].prepare( getCustom( false ) );
                else 
                    m_claim[k].prepare();
            }
            catch( DataException e ) {
                if( m_claim[k].wrongComp() == null )
                    throw e;
                else 
                    setWrong( m_claim[k].wrongComp(), e );
            }
            if( m_claim[k].paramMaturity() > m_paramMaturity )
                m_paramMaturity = m_claim[k].paramMaturity();
        }
    }

    if( m_paramMaturity == 0 )
        panic( "Please define claims in your portfolio" );
}


//
//   p a r a m M a t u r i t y
//

public int paramMaturity()

{
    return m_paramMaturity;
}


//
//   p r o t P o r t f o l i o
//

public String protPortfolio()

{
    String q = "";
    String s = "portfolio P { ";

    int n = 0;

    for( int k = 0; k < m_numOfClaims; ++k ) {
        if( m_active[k] ) {
            q += m_claim[k].protClaim() + "\n";
            if( n > 0 )
                s += ", ";
            s += m_claim[k].protPosition();
            ++n;
        }
    }

    s += " }\n";
    return q + s;
}


//
//   c u s t o m D l g A l e r t
//

public void customDlgAlert()

{
    if( m_dlgCustom != null && m_dlgCustom.isActive() ) {
        if( m_lastLinked >= 0 )
            m_claim[m_lastLinked].retrieveCustom( m_dlgCustom.custom() );        
        m_customBounds = m_dlgCustom.bounds();
    }
}


//
//   b o r r o w E x a m p l e s
//

public String[] borrowExamples()

{
    return m_myExamples;
}


//
//   c o p y F r o m
//

public void copyFrom( Portfolio portfolio )

{
    if( portfolio.m_dlgCustom != null && portfolio.m_dlgCustom.isActive() )
        portfolio.customDlgAlert();

    m_dlgCustom = portfolio.m_dlgCustom;

    if( m_dlgCustom != null ) {
        portfolio.m_dlgCustom = null;
        m_dlgCustom.attach( this );
    }

    m_lastFocused = -1;
    m_lastLinked = -1;

    int n = m_numOfClaims;

    if( n > portfolio.m_numOfClaims )
        n = portfolio.m_numOfClaims;

    for( int i = 0; i < n; ++i )
        m_claim[i].copyFrom( portfolio.m_claim[i] );

    m_customBounds = portfolio.m_customBounds;
}


//
//   c r e a t e T a b l e 1
//

private Panel createTable1()

{
    Panel table = new Panel();

    GridBagLayout layout = new GridBagLayout();
    table.setLayout( layout );

    GridBagConstraints c = new GridBagConstraints();
    c.anchor = GridBagConstraints.NORTHWEST;
    c.ipadx = 10;
    c.gridy = 0;

    add( table, new Label( "Type" ), c );
    add( table, new Label( "Expires" ), c );
    add( table, new Label( "Strike" ), c );
    add( table, new Label( "Up&Out" ), c );
    add( table, new Label( "Down&Out" ), c );
    add( table, new Label( "Position" ), c );
    add( table, new Label( "Amount" ), c );

    for( int k = 0; k < m_numOfClaims; ++k ) {
        m_claim[k] = new Claim( k );
        m_claim[k].add( table, k + 1 );
    }

    if( Pool.m_bgColor != null )
        table.setBackground( Pool.m_bgColor );

    return table;
}


//
//   g e t C u s t o m
//

private Custom getCustom( boolean createIfNecessary )

{
    if( m_dlgCustom != null && ! m_dlgCustom.isActive() ) {
        m_customBounds = m_dlgCustom.bounds();
        m_dlgCustom = null;
    }

    if( m_dlgCustom == null ) {
        if( createIfNecessary ) {
            m_dlgCustom = new CustomDialog( this );
            if( m_customBounds != null )
                m_dlgCustom.move( m_customBounds.x, m_customBounds.y );
            m_dlgCustom.show();
        }
        else {
            return null;
        }
    }

    return m_dlgCustom.custom();
}

} // end of class
