// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   T o o l b a r
//

public class Toolbar extends Panel {


//
//   v a r i a b l e s
//

private Button m_start;
private Button m_stop;

private Button m_portfolio;
private Button m_scenario;
private Button m_advanced;

private Button m_oneClick;


//
//   T o o l b a r
//

public Toolbar()
    
{
    GridBagLayout layout = new GridBagLayout();
    setLayout( layout );

    GridBagConstraints c = new GridBagConstraints();
    c.fill = GridBagConstraints.BOTH;
    c.gridy = 0;
    c.weightx = 0;

    m_start = new ToolbarButton( Id.START, "Start" );
    m_stop = new ToolbarButton( Id.STOP, "Stop" );
    m_portfolio = new ToolbarButton( Id.PORTFOLIO, "Portfolio" );
    m_scenario = new ToolbarButton( Id.SCENARIO, "Scenario" );
    m_advanced = new ToolbarButton( Id.ADVANCED, "Advanced" );
    m_oneClick = new ToolbarButton( Id.ONECLICK, "One-Click" );

    m_stop.disable();
    m_stop.setForeground( Color.red );

    layout.setConstraints( m_start, c );
    add( m_start );

    layout.setConstraints( m_stop, c );
    add( m_stop );

    c.insets = new Insets( 0, 10, 0, 0 );
    layout.setConstraints( m_portfolio, c );
    add( m_portfolio );

    c.insets = new Insets( 0, 0, 0, 0 );
    layout.setConstraints( m_scenario, c );
    add( m_scenario );

    layout.setConstraints( m_advanced, c );
    add( m_advanced );

    Canvas remainder = new Canvas();
    c.weightx = 1;
    layout.setConstraints( remainder, c );
    add( remainder );

    c.insets = new Insets( 0, 10, 0, 0 );
    c.weightx = 0;
    layout.setConstraints( m_oneClick, c );
    add( m_oneClick );

    wizardMode();

    if( Pool.m_bgColor != null )
        setBackground( Pool.m_bgColor );
}


//
//   c o m m a n d
//

public int command( Event evt )

{
    if( evt.target instanceof ToolbarButton )
        return ( (ToolbarButton) evt.target ).m_id;
    return Id.UNKNOWN;
}


//
//   b e f o r e R u n
//

public void beforeRun()

{
    m_start.disable();
    m_stop.enable();
}


//
//   a f t e r R u n
//

public void afterRun()

{
    m_start.enable();
    m_stop.disable();
}


//
//   w i z a r d M o d e
//

public void wizardMode()

{
    m_portfolio.show();
    m_scenario.show();
    m_advanced.show();

    m_oneClick.setLabel( "One-Click" );

    invalidate();
    validate();
}


//
//   o n e C l i c k M o d e
//

public void oneClickMode()

{
    m_portfolio.hide();
    m_scenario.hide();
    m_advanced.hide();

    m_oneClick.setLabel( "Wizard" );
}

} // end of class


///////////////////////////////////////////////////////////////////

//
//   T o o l b a r B u t t o n
//

class ToolbarButton extends Button {


//
//   v a r i a b l e s
//

public int m_id;


//
//   T o o l b a r B u t t o n
//

public ToolbarButton( int id, String label )

{
    super( label );
    m_id = id;
}

    
//
//   m i n i m u m S i z e
//
    
public Dimension minimumSize()

{
    FontMetrics f = getFontMetrics( getFont() );

    return new Dimension(
        f.stringWidth( "XXXXXXXXXXX" ) + 1,
        3 * ( f.getMaxAscent() + f.getMaxDescent() ) / 2 );
}


//
//   p r e f e r r e d S i z e
//

public Dimension preferredSize()

{
    return minimumSize();
}

} // end of class
