// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.net.URLConnection;
import java.net.ContentHandler;


///////////////////////////////////////////////////////////////////

//
//   C o n t e n t H a n d l e r F a c t o r y
//

public class ContentHandlerFactory
    implements java.net.ContentHandlerFactory {


//
//   v a r i a b l e s
//

    // handlers initialized?

private static boolean m_registered = false;

    // the handlers:

private static ContentTextPlain m_textPlain;


//
//   r e g i s t e r
//

public static synchronized void register()

{
    if( ! m_registered ) {
        try {
            URLConnection.setContentHandlerFactory(
                new ContentHandlerFactory() );
        }
        catch( Error e ){
            // ignore
        }
        m_textPlain = new ContentTextPlain();
        m_registered = true;
    }
}

    
//
//   c r e a t e C o n t e n t H a n d l e r
//
    
public ContentHandler createContentHandler( String mimetype )

{
    if( mimetype.equals( "text/plain" ) )
        return m_textPlain;
    if( mimetype.equals( "text/html" ) )
        return m_textPlain;
    if( mimetype.equals( "text/shtml" ) )
        return m_textPlain;
    return null;
}
    
} // end of class
