// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.awt.TextField;


///////////////////////////////////////////////////////////////////

//
//   E x t T e x t F i e l d
//

public class ExtTextField extends TextField {


//
//   v a r i a b l e s
//

private int m_id;


//
//   E x t C h o i c e
//

public ExtTextField( int id, int length )

{
    super( length );
    m_id = id;
}


//
//   i d
//

public int id()

{
    return m_id;
}


//
//   h a s V a l u e
//

public boolean hasValue()

{
    return ( getText().trim().length() > 0 );
}


//
//   h a s V a l u e
//

public boolean hasValue( int noValue )

{
    if( ! hasValue() )
        return false;

    try {
        if( Integer.valueOf( getText().trim() ).doubleValue() == noValue )
            return false;
    }
    catch( NumberFormatException e ) {
        return true;    // report error later
    }

    return true;
}


//
//   h a s V a l u e
//

public boolean hasValue( double noValue )

{
    if( ! hasValue() )
        return false;

    try {
        if( Double.valueOf( getText().trim() ).doubleValue() == noValue )
            return false;
    }
    catch( NumberFormatException e ) {
        return true;    // report error later
    }

    return true;
}


//
//   g e t T e x t
//

public String getText()

{
    return super.getText().trim();
}


//
//   g e t I n t
//

public int getInt()
    throws DataException

{
    int i = 0;

    try { 
        i = Integer.valueOf( getText().trim() ).intValue();
    }
    catch( NumberFormatException e ) {
        throw new DataException( "Not a valid number" );
    }

    return i;
}


//
//   g e t P o s I n t
//

public int getPosInt()
    throws DataException

{
    int i = getInt();
    if( i <= 0 )
        throw new DataException( "Number must be strictly positive" );
    return i;
}


//
//   g e t D o u b l e
//

public double getDouble()
    throws DataException

{
    double d = 0;

    try { 
        d = Double.valueOf( getText().trim() ).doubleValue();
    }
    catch( NumberFormatException e ) {
        throw new DataException( "Not a valid number" );
    }

    return d;
}


//
//   g e t P o s D o u b l e
//

public double getPosDouble()
    throws DataException

{
    double d = getDouble();
    if( d <= 0 )
        throw new DataException( "Number must be strictly positive" );
    return d;
}


//
//   g e t N o n N e g D o u b l e
//

public double getNonNegDouble()
    throws DataException

{
    double d = getDouble();
    if( d < 0 )
        throw new DataException( "Number must be nonnegative" );
    return d;
}

} // end of class
