// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.awt.*;

///////////////////////////////////////////////////////////////////

//
//   M e s s a g e B o x
//

public class MessageBox extends Dialog {

    
//
//   v a r i a b l e s
//

    // style of message box

public final static int STYLE_OK          = 0;
public final static int STYLE_OKCANCEL    = 1;

public final static int STYLE_YESNO       = 2;
public final static int STYLE_YESNOCANCEL = 3;

    // return value

public final static int ID_OK     = 0;
public final static int ID_CANCEL = 1;

public final static int ID_YES    = 2;
public final static int ID_NO     = 3;

private Button m_ok;
private Button m_cancel;
private Button m_yes;
private Button m_no;

private int m_style;
private int m_cmd;


//
//   M e s s a g e B o x
//

public MessageBox( Frame parent, String title, String msg )

{
    this( parent, title, msg, STYLE_OK );
}


//
//   M e s s a g e B o x
//

public MessageBox( Frame parent, String title, String msg, int style )

{
    super( parent, title, true );
    m_style = style;
    
    Panel buttons = new Panel();
    buttons.setLayout( new FlowLayout() );

    if( m_style == STYLE_OK || m_style == STYLE_OKCANCEL ) {
        m_ok = new Button( "Ok" );
        buttons.add( m_ok );
    }
    else
    if( m_style == STYLE_YESNO || m_style == STYLE_YESNOCANCEL ) {
        m_yes = new Button( "Yes" );
        buttons.add( m_yes );
        m_no = new Button( "No" );
        buttons.add( m_no );
    }
    else {
        throw new InternalError();
    }

    if( m_style == STYLE_OKCANCEL || m_style == STYLE_YESNOCANCEL ) {
        m_cancel = new Button( "Cancel" );
        buttons.add( m_cancel );
    }

    MultiLineLabel label = new MultiLineLabel( msg );

    add( "North", label );
    add( "South", buttons );

    pack();

    m_cmd = ID_CANCEL;
}


//
//   g o
//

public int go()

{
    show();
    return m_cmd;
}


//
//   c m d
//

public int cmd()

{
    return m_cmd;
}


//
//   h a n d l e E v e n t
//

public boolean handleEvent( Event evt )

{
    switch( evt.id ) {
        case Event.WINDOW_DESTROY:
            quit();
            return true;

        default:
            return super.handleEvent( evt );
    }			 
}


//
//   a c t i o n
//

public boolean action( Event evt, Object what )

{
    if( evt.id == Event.ACTION_EVENT ) {
        if( evt.target instanceof Button ) {
            Button b = (Button) evt.target;

            if( b == m_ok )
                m_cmd = ID_OK;
            else
            if( b == m_cancel )
                m_cmd = ID_CANCEL;
            else
            if( b == m_yes )
                m_cmd = ID_YES;
            else
            if( b == m_no )
                m_cmd = ID_NO;
        }
        quit();
        return true;
    }

    return false;
}


//
//   q u i t
//

private void quit()

{
    hide();
	dispose();
}


//
//   o k
//

public static int ok( Frame parent, String title, String msg )

{
    MessageBox mb = new MessageBox( parent, title, msg, STYLE_OK );
    return mb.go();
}


//
//   o k C a n c e l
//

public static int okCancel( Frame parent, String title, String msg )

{
    MessageBox mb = new MessageBox( parent, title, msg, STYLE_OKCANCEL );
    return mb.go();
}


//
//   y e s N o
//

public static int yesNo( Frame parent, String title, String msg )

{
    MessageBox mb = new MessageBox( parent, title, msg, STYLE_YESNO );
    return mb.go();
}


//
//   y e s N o C a n c e l
//

public static int yesNoCancel( Frame parent, String title, String msg )

{
    MessageBox mb = new MessageBox( parent, title, msg, STYLE_YESNOCANCEL );
    return mb.go();
}

} // end of class
