// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.awt.*;
import java.util.*;

///////////////////////////////////////////////////////////////////

//
//   R e p o r t A r e a
//

public class ReportArea extends PublicText {

    
//
//   v a r i a b l e s
//

private int m_lineLength[] = null;
private int m_numOfLines = 0;

private int m_nextLine = 0;     // next line to be filled
private int m_linesFilled = 0;  // number of lines filled
private int m_linesLost = 0;    // number of lines lost

private boolean m_newLine = true;


//
//   R e p o r t A r e a
//

public ReportArea()

{
    this( 30 );
}


//
//   R e p o r t A r e a
//

public ReportArea( int numOfLines )

{
    m_numOfLines = Math.max( numOfLines, 2 );
    m_lineLength = new int[m_numOfLines];
    setEditable( false );
    setBackground( Color.white );
    tryFixedFont();
}


//
//   m i n i m u m S i z e
//
    
public Dimension minimumSize()

{
    return new Dimension( 0, 0 );
}


//
//   p r e f e r r e d S i z e
//

public Dimension preferredSize()

{
    FontMetrics f = getFontMetrics( getFont() );
    return new Dimension( 60 * f.charWidth( 'M' ), 8 * f.getHeight() );
}


//
//   c l e a r
//

public synchronized void clear()

{
    m_nextLine = 0;
    m_linesFilled = 0;
    m_linesLost = 0;
    m_newLine = true;
    setText( "" );
}


//
//   p r i n t
//

public synchronized void print( String text, boolean nlIfNecessary )

{
    if( nlIfNecessary )
        m_newLine = true;
    appendText( text );
}


//
//   p r i n t
//

public synchronized void print( String text )

{
    appendText( text );
}


//
//   p r i n t
//

public void print( Object obj, boolean nlIfNecessary )

{
    print( obj.toString(), nlIfNecessary );
}


//
//   p r i n t
//

public void print( Object obj )

{
    print( obj.toString() );
}


//
//   p r i n t l n
//

public void println( String text, boolean nlIfNecessary )

{
    print( text + "\n", nlIfNecessary );
}


//
//   p r i n t l n
//

public void println( String text )

{
    print( text + "\n" );
}


//
//   p r i n t l n
//

public void println( Object obj, boolean nlIfNecessary )

{
    println( obj.toString(), nlIfNecessary );
}


//
//   p r i n t l n
//

public void println( Object obj )

{
    println( obj.toString() );
}


//
//   a p p e n d
//

public void appendText( String text )

{
    int j, j1, l;
    String s;
	
    l = text.length();
    j = text.indexOf( '\n' );

    s = ( j < 0 ) ? text : text.substring( 0, j );

    if( m_newLine ) {
        addLine( s );
        m_newLine = false;
    }
    else {
        expandLine( s );
    }

    while( j >= 0 && j + 1 < l ) {
        j1 = text.indexOf( '\n', ++j );
        if( j1 < 0 )
            addLine( text.substring( j ) );
        else
            addLine( text.substring( j, j1 ) );
        j = j1;
    }

    if( j + 1 == l )
        m_newLine = true;
}


//
//   a d d L i n e
//

private void addLine( String text )

{
    if( m_linesFilled == m_numOfLines ) {
        if( m_linesLost == 0 )
            m_linesLost = 2;
        else
            ++m_linesLost;

        int k = m_nextLine + 1;     // this is the line to go
        if( k == m_numOfLines )
            k = 0;

        String s = "[" + m_linesLost + " lines lost]";
        replaceText( s, 0, m_lineLength[m_nextLine] + m_lineLength[k] + 1 );
        m_lineLength[k] = s.length();
    }
    else {
        ++m_linesFilled;
    }

    m_lineLength[m_nextLine] = text.length();

    if( m_linesFilled > 1 )
        super.appendText( "\n" );
    super.appendText( text );

    if( ++m_nextLine == m_numOfLines )
        m_nextLine = 0;
}


//
//   e x p a n d L i n e
//

private void expandLine( String text )

{
    int k = m_nextLine - 1;
    if( k < 0 )
        k = m_numOfLines = 1;

    m_lineLength[k] += text.length();
    super.appendText( text );
}

} // end of class
