// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.awt.*;
import java.util.*;

///////////////////////////////////////////////////////////////////

//
//   S t a t u s L i n e
//

public class StatusLine extends Panel implements Runnable {


//
//   v a r i a b l e s
//

private GridBagLayout m_layout;

private Label m_msgArea;
private StatusLineTimerLabel m_timerArea;

private long m_timerZero;

private Integer m_threadLock = new Integer( 0 );
private Thread m_thread;


//
//   S t a t u s L i n e
//
    
public StatusLine()
    
{
    m_layout = new GridBagLayout();
    setLayout( m_layout );

    GridBagConstraints c = new GridBagConstraints();
    c.fill = GridBagConstraints.BOTH;
    c.gridy = 0;

    m_msgArea = new Label( "" );
    m_timerArea = new StatusLineTimerLabel();

    c.weightx = 1;
    m_layout.setConstraints( m_msgArea, c );
    add( m_msgArea );

    c.weightx = 0;
    m_layout.setConstraints( m_timerArea, c );
    add( m_timerArea );
}


//
//   s e t M s g
//

public void setMsg( String msg )

{
    m_msgArea.setText( msg );
}


//
//   s t a r t T i m e r
//

public void startTimer()

{
    synchronized( m_threadLock ) {
        if( m_thread != null ) {
            m_thread.stop();
            m_thread = null;
        }
        m_timerZero = System.currentTimeMillis();

        m_thread = new Thread( this );
        m_thread.setPriority( Thread.MIN_PRIORITY );
        m_thread.start();
    }
}


//
//   s t o p T i m e r
//

public void stopTimer()

{
    synchronized( m_threadLock ) {
        if( m_thread != null ) {
            m_thread.stop();
            m_thread = null;
            m_timerArea.setText( "" );
        }
    }
}


//
//   r u n
//

public void run()

{
    while( true ) {
        long l = ( System.currentTimeMillis() - m_timerZero ) / 1000; 

        long h = l / 3600;
        long m = ( l / 60 ) % 60;
        long s = l % 60;

        String buf = "" + m;
        if( m < 10 )
            buf = "0" + buf;

        if( h > 0 ) {
            buf = h + ":" + buf;
            if( h < 10 )
                buf = "0" + buf;
        }
        else {
            buf += ":";
            if( s < 10 )
                buf += "0";
            buf += s;
        }

        m_timerArea.setText( buf );

        try { 
            Thread t = null;

            synchronized( m_threadLock ) {
                if( m_thread == null )
                    return;
                t = m_thread;
            }
            t.sleep( 1000 );
        }
        catch( InterruptedException e ) {
            return;
        }
    }
}

} // end of class


///////////////////////////////////////////////////////////////////

//
//   S t a t u s L i n e T i m e r L a b e l
//

class StatusLineTimerLabel extends Label {


//
//   S t a t u s L i n e T i m e r L a b e l
//
    
public StatusLineTimerLabel()

{
    super( "", Label.RIGHT );
}


//
//   m i n i m u m S i z e
//
    
public Dimension minimumSize()

{
    FontMetrics f = getFontMetrics( getFont() );

    return new Dimension(
        f.stringWidth( "99:99" ) + 1,
        f.getMaxAscent() + f.getMaxDescent() );
}


//
//   p r e f e r r e d S i z e
//

public Dimension preferredSize()

{
    return minimumSize();
}

} // end of class
