// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   T r i v i a l L a y o u t
//

public class TrivialLayout implements LayoutManager {


//
//   v a r i a b l e s
//

private int m_hgap;
private int m_vgap;

private Component m_comp;


//
//   T r i v i a l L a y o u t
//

public TrivialLayout()

{
    this( 0, 0 );
}


//
//   T r i v i a l L a y o u t
//

public TrivialLayout( int hgap, int vgap )

{
    m_hgap = hgap;
    m_vgap = vgap;
}


//
//   a d d L a y o u t C o m p o n e n t
//

public void addLayoutComponent( String name, Component comp )

{
    m_comp = comp;
}


//
//   r e m o v e L a y o u t C o m p o n e n t
//

public void removeLayoutComponent( Component comp )

{
    if( m_comp == comp )
        m_comp = null;
}


//
//   m i n i m u m L a y o u t S i z e
//

public Dimension minimumLayoutSize( Container target )

{
	Dimension dim = new Dimension( m_hgap * 2, m_vgap * 2 );

    if( m_comp != null && m_comp.isVisible() ) {
        Dimension d = m_comp.minimumSize();
        dim.width += d.width;
        dim.height += d.height;
    }

	Insets insets = target.insets();

	dim.width += insets.left + insets.right;
	dim.height += insets.top + insets.bottom;

	return dim;
}


//
//   p r e f e r r e d L a y o u t S i z e
//

public Dimension preferredLayoutSize( Container target )

{
	Dimension dim = new Dimension( m_hgap * 2, m_vgap * 2 );

    if( m_comp != null && m_comp.isVisible() ) {
        Dimension d = m_comp.preferredSize();
        dim.width += d.width;
        dim.height += d.height;
    }

	Insets insets = target.insets();

	dim.width += insets.left + insets.right;
	dim.height += insets.top + insets.bottom;

	return dim;
}


//
//   l a y o u t C o n t a i n e r
//

public void layoutContainer( Container target )

{
	if( m_comp == null || ! m_comp.isVisible() )
        return;

	Insets insets = target.insets();
    Dimension size = target.size();

	int top = insets.top + m_vgap;
	int height = size.height - insets.bottom - top - m_vgap;
	int left = insets.left + m_hgap;
	int width = size.width - insets.right - left - m_hgap;

    Dimension min = m_comp.minimumSize();
    Dimension pref = m_comp.preferredSize();

    if( width < min.width )
        width = min.width;
    else
        if( width > pref.width )
            width = pref.width;

    if( height < min.height )
        height = min.height;
    else
        if( height > pref.height )
            height = pref.height;

    m_comp.reshape( left, top, width, height );
}
   
} // end of class
