// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_BOOTSTRAP_)
#define _MTG_BOOTSTRAP_

#include "MtgHeap.h"
#include "MtgFileName.h"
#include "MtgInterestSpline.h"
#include "MtgObject.h"

#if defined(_MTG_WITH_TCL)
    #include "MtgTclTools.h"
#endif

MTG_BEGIN_NAMESPACE

class tParser;
class tPortfolio;


//
//   t B o o t s t r a p
//

#if defined(_MTG_WITH_TCL)
class tBootstrap : public tObject, tTclTools {
#else
class tBootstrap : public tObject {
#endif

    typedef tObject super;

    tInterestSpline m_Spline;

    tFileName m_OutFile;        // save entire object here
    tFileName m_OutLegFile;     // save legs plain here
    tFileName m_OutGnuDataFile; // save samples for gnuplot here    
    tFileName m_OutGnuTicsFile; // save ticmarks for gnuplot here

    void copyFrom( const tBootstrap& Boot );

    tRetCode parseItem( tParser& Parser );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );
    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );

public:

    tBootstrap();
    tBootstrap( const tBootstrap& Boot );

    ~tBootstrap();

    tBootstrap& operator=( const tBootstrap& Boot );

    tObject* clone() const;

    tRetCode finalize();

    tRetCode autoActivate() {
        return save();
    }

    tInterestSpline& spline() {
        MTG_ASSERT( isFinalized() );
        return m_Spline;
    }

        // Save to all files that have been registered.

    tRetCode save();

    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );

#if defined(_MTG_WITH_TCL)

        // Used from tShell to create drift commands:

    static bool tclTest( const tObject* pObj );
    static int tclCommand( ClientData clientData, Tcl_Interp *pInterp,
        int objc, Tcl_Obj *CONST objv[] );
    static void tclDelete( ClientData clientData );

#endif
};

MTG_END_NAMESPACE

#endif

