// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgCalendar.h"
#include "MtgParser.h"

MTG_BEGIN_NAMESPACE


//
//   c o p y F r o m
//

void tCalendar::copyFrom( const tCalendar& Calendar )

{
    if( &Calendar == this )
        return;

    m_gDayUnit = Calendar.m_gDayUnit;
    super::copyFrom( Calendar );
}


//
//   p a r s e P a r a m
//

tRetCode tCalendar::parseParam( tParser& Parser, tParseInfoStub& Info )

{
    tRetCode nRet;
    double gDaysPerYear;

    tParseInfo& I = static_cast<tParseInfo&>( Info );

    if( Parser.curToken() == xTokDaysPerYear ) {
        if( I.m_bDayUnit )
            return Parser.setError( "day unit already defined" );
        if( ( nRet = Parser.readToken() ) != OK ||
            ( nRet = Parser.scanPosDouble( gDaysPerYear ) ) != OK ) {
            return nRet;
        }
        m_gDayUnit = 1 / gDaysPerYear;
        I.m_bDayUnit = true;
    }

    return super::parseParam( Parser, Info );
}


//
//   t C a l e n d a r
//

tCalendar::tCalendar()

{
    m_gDayUnit = stdDayUnit();
}


//
//   t C a l e n d a r
//

tCalendar::tCalendar( const tCalendar& Calendar )

{
    m_gDayUnit = Calendar.m_gDayUnit;
}


//
//   ~ t F a c t o r
//

tCalendar::~tCalendar()

{
}


//
//   o p e r a t o r =
//

tCalendar& tCalendar::operator=( const tCalendar& Calendar )

{
    if( &Calendar != this )
        copyFrom( Calendar );
    return *this;
}


//
//   c l o n e
//

tObject* tCalendar::clone() const

{
    return new tCalendar( *this );
}


//
//   s e t D a y s P e r Y e a r
//

void tCalendar::setDaysPerYear( double gDaysPerYear )

{
    MTG_ASSERT( gDaysPerYear > 0 );

    m_gDayUnit = 1 / gDaysPerYear;
    touch();
}


//
//   f i n a l i z e
//

tRetCode tCalendar::finalize()

{
    return super::finalize();
}


//
//   p a r s e
//

tRetCode tCalendar::parse( tParser& Parser, tSystem& System,
    tObject*& pObj )

{
    tRetCode nRet;
    tCalendar* pCalendar;
    tParseInfo Info;

    Info.m_bDayUnit = false;

    if( ( nRet = Parser.scanBeginOfObj() ) != OK )
        return nRet;

    pCalendar = new tCalendar;
    pCalendar->setSystem( System );

    if( ( nRet = pCalendar->super::parse( Parser, &Info ) ) != OK ) {
        delete pCalendar;
        return nRet;
    }

    pObj = pCalendar;
    return OK;
}

MTG_END_NAMESPACE