// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgCashflow.h"
#include "MtgSystem.h"

MTG_BEGIN_NAMESPACE


//
//   c o p y F r o m
//

void tCashflow::copyFrom( const tCashflow& CF )

{
    if( &CF == this )
        return;

    m_nDay = CF.m_nDay;
    m_Date = CF.m_Date;

    super::copyFrom( CF );
}


//
//   t C a s h f l o w
//

tCashflow::tCashflow( tSystem& System, int nDay )

{
    MTG_ASSERT( nDay >= 0 );

    setSystem( System );

    m_nDay = nDay;
    m_Date = System.base() + nDay;
}


//
//   t C a s h f l o w
//

tCashflow::tCashflow( tSystem& System, tDate Date )

{
    MTG_ASSERT( Date >= System.base() );

    setSystem( System );

    m_Date = Date;
    m_nDay = System.dateIndex( Date );
}


//
//   t C a s h f l o w
//

tCashflow::tCashflow( const tCashflow& CF )

{
    m_nDay = CF.m_nDay;
    m_Date = CF.m_Date;
}


//
//   ~ t C a s h f l o w
//

tCashflow::~tCashflow()

{
}


//
//   g e n e r a t e
//

double tCashflow::generate( tEngine& Engine, const tClaim& Claim )

{
    return 0;
}

MTG_END_NAMESPACE