// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_CASHFLOW_)
#define _MTG_CASHFLOW_

#include "MtgWithSystem.h"

MTG_BEGIN_NAMESPACE

class tClaim;
class tEngine;
   

//
//   t C a s h f l o w
//
    
class tCashflow : public tWithSystem {
                
    typedef tWithSystem super;

    int m_nDay;     // day of cashflow, under day count convention
    tDate m_Date;   // date of cashflow, for calendar date based
                    // processing

protected:

    void copyFrom( const tCashflow& CF );

        // generate() must throw an exception if anything goes wrong.

    virtual double generate( tEngine& Engine, const tClaim& Claim );

public:

    tCashflow( tSystem& System, int nDay );
    tCashflow( tSystem& System, tDate Date );

    tCashflow( const tCashflow& CF );

    virtual ~tCashflow();

    virtual tCashflow* clone() const = 0;

    int day() const {
        return m_nDay;
    }

    tDate date() const {
        return m_Date;
    }

    friend class tClaim;
};

MTG_END_NAMESPACE

#endif
