// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_COLOR_)
#define _MTG_COLOR_

extern "C" {
    #include <gd.h>
}

MTG_BEGIN_NAMESPACE


//
//   t C o l o r
//

class tColor {

    int m_R;
    int m_G;
    int m_B;

public:

    tColor();
    tColor( int R, int G, int B );

    tColor( const tColor& Color );

    tColor& operator=( const tColor& Color );

    bool operator==( const tColor& Color );
    bool operator!=( const tColor& Color );

    int R() const { return m_R; }
    int G() const { return m_G; }
    int B() const { return m_B; }

        // In the package GD, colors need to be allocated.

    int allocate( gdImagePtr Ptr ) const;
};


//
//   o b j e c t s
//

extern tColor Black;
extern tColor White;
extern tColor Gray;
extern tColor Red;
extern tColor Green;
extern tColor Blue;

MTG_END_NAMESPACE

#endif
