// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_COMPILER_)
#define _MTG_COMPILER_

#if defined(__GNUC__)
    #include <unistd.h>
    #include <signal.h>
    #define _MTG_UNIX
#endif

#if defined(_WIN32)
    #define _MTG_HAS_NAMESPACES
    #define _MTG_HAS_BOOL
#elif defined(__GNUC__)
    #define _MTG_HAS_BOOL
    #define _MTG_ANSI_FOR
#endif



//
//   n a m e s p a c e s
//

#if defined(_MTG_HAS_NAMESPACES)

#define MTG_BEGIN_NAMESPACE       namespace Mtg {
#define MTG_END_NAMESPACE         }
#define MTG_USING_NAMESPACE       using namespace Mtg;
#define MTG_DECLARING_NAMESPACE   Mtg::
#define MTG_ACCESSING_NAMESPACE   Mtg::

#define MTG_USING_OTHER_NAMESPACE( space ) \
    using namespace space;

#else

#define MTG_BEGIN_NAMESPACE
#define MTG_END_NAMESPACE
#define MTG_USING_NAMESPACE
#define MTG_DECLARING_NAMESPACE 
#define MTG_ACCESSING_NAMESPACE   ::

#define MTG_USING_OTHER_NAMESPACE( space ) 

#endif


//
//   b o o l
//

#if ! defined(_MTG_HAS_BOOL)

typedef int bool;
const int true = 1;
const int false = 0;

#endif


//
//    A N S I   f o r
//

#if defined(_MTG_ANSI_FOR)
    #define MTG_FOR_INIT( type ) type
#else
    #define MTG_FOR_INIT( type )
#endif

#endif
