// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgDateExpr.h"
#include "MtgParser.h"

MTG_BEGIN_NAMESPACE


//
//   i n i t
//

void tDateExpr::init()

{
    m_nType = xDate;
}


//
//   c l e a n u p
//

void tDateExpr::cleanup()

{
}


//
//   c o p y F r o m
//

void tDateExpr::copyFrom( tDateExpr& Expr )

{
    if( &Expr == this )
        return;

    m_nType = Expr.m_nType;
    m_Date = Expr.m_Date;
}


//
//   s e t T y p e
//

void tDateExpr::setType( tType nType, tDate Date )

{
    MTG_ASSERT( nType == xDate );

    cleanup();

    m_nType = nType;
    m_Date = Date;
}


//
//   p a r s e 1
//

tRetCode tDateExpr::parse1( tParser& Parser, int nFlags )

{
    tRetCode nRet;
    tDate Date;

    if( Parser.tryDate( Date ) ) {
        if( ( nRet = Parser.readToken() ) != OK )
            return nRet;
        setType( xDate, Date );
        return OK;
    }

    return Parser.setError( MALFORMED_EXPRESSION );
}


//
//   p a r s e 1
//

tRetCode tDateExpr::parse1( tParser& Parser )

{
    return parse1( Parser, ALLOW_ALL );
}


//
//   t D a t e E x p r
//

tDateExpr::tDateExpr()

{
    init();
}


//
//   t D a t e E x p r
//

tDateExpr::tDateExpr( tDateExpr& Expr )

{
    init();
    copyFrom( Expr );
}


//
//   ~ t D a t e E x p r
//

tDateExpr::~tDateExpr()

{
    cleanup();
}


//
//   c l o n e
//

tExpression* tDateExpr::clone()

{
    return new tDateExpr( *this );
}


//
//   o p e r a t o r =
//

tDateExpr& tDateExpr::operator=( tDateExpr& Expr )

{
    if( &Expr != this )
        copyFrom( Expr );
    return *this;
}


//
//   r e s o l v e
//

tRetCode tDateExpr::resolve( int nThisId, tLookup<int>& Claim,
    tLookup<int>& Factor, tHeap<tFactor*>& FactorPtr,
    tPortfolio& Pf, int nFlags )

{
    return OK;
}


//
//   r e s o l v e
//

tRetCode tDateExpr::resolve( int nThisId, tLookup<int>& Claim,
    tLookup<int>& Factor, tHeap<tFactor*>& FactorPtr,
    tPortfolio& Pf )

{
    return resolve( nThisId, Claim, Factor, FactorPtr, Pf, ALLOW_ALL );
}


//
//   g e t E v e n t s
//

void tDateExpr::getEvents( tSeqEvGenerator& EvGen ) const

{
    // recurse into numerical subexpressions
}


//
//   g e t B a r r i e r s
//

void tDateExpr::getBarriers( const tFactor* pFactor,
    tHeap<double>& Barrier ) const

{
    // recurse into numerical subexpressions
}


//
//   g e t C o n s t a n t s
//

void tDateExpr::getConstants( tHeap<double>& Constant ) const

{
    // no recursion necessary
}


//
//   a p p l y
//

tDate tDateExpr::apply( tEngine& Engine, double gMultiplier,
    double gUnitValue, bool& bValid )

{
    bValid = true;

    switch( m_nType ) {
        case xDate :
            return m_Date;

        default :
            throw tException( NOT_IMPLEMENTED );
    }

    return m_Date;  // for the compiler
}


//
//   p a r s e
//

tRetCode tDateExpr::parse( tParser& Parser, int nFlags )

{
    tRetCode nRet;
    tDate Date;

        // First try the most basic expression: a date.

    if( Parser.tryDate( Date ) ) {
        if( ( nRet = Parser.readToken() ) != OK )
            return nRet;
        setType( xDate, Date );
        return OK;
    }

        // Now try obligatory '{', '}'.

    if( ( nRet = Parser.scanBeginOfObj() ) != OK ||
        ( nRet = parse1( Parser, nFlags ) ) != OK ||
        ( nRet = Parser.scanEndOfObj() ) != OK ) {
        return nRet;
    }

    return OK;
}


//
//   p a r s e
//

tRetCode tDateExpr::parse( tParser& Parser )

{
    return parse( Parser, ALLOW_ALL );
}

MTG_END_NAMESPACE

