// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_DATE_EXPR_)
#define _MTG_DATE_EXPR_

#include "MtgExpression.h"
#include "MtgLookup.h"

MTG_BEGIN_NAMESPACE

class tEngine;
class tParser;


//
//   t D a t e E x p r
//

class tDateExpr : public tExpression {

public:

        // These are the valid expression types.

    enum tType {
        xDate
    };

private:

    tType m_nType;
    tDate m_Date;

        // Some helper functions.

    void init();
    void cleanup();

    void copyFrom( tDateExpr& Expr );

    void setType( tType nType, tDate Date );

    tRetCode parse1( tParser& Parser, int nFlags );
    tRetCode parse1( tParser& Parser );

public:

    tDateExpr();
    tDateExpr( tDateExpr& Expr );

    ~tDateExpr();

    tExpression* clone();

    tDateExpr& operator=( tDateExpr& Expr );

    tRetCode resolve( int nThisId, tLookup<int>& Claim,
        tLookup<int>& Factor, tHeap<tFactor*>& FactorPtr,
        tPortfolio& Pf, int nFlags );

    tRetCode resolve( int nThisId, tLookup<int>& Claim,
        tLookup<int>& Factor, tHeap<tFactor*>& FactorPtr,
        tPortfolio& Pf );

    void getEvents( tSeqEvGenerator& EvGen ) const;
    void getBarriers( const tFactor* pFactor, tHeap<double>& Barrier ) const;
    void getConstants( tHeap<double>& Constant ) const;

        // The next functions throw an exception if something goes
        // wrong. bValid is used to determine whether the missing
        // else branch of any if..then..endif clause has been
        // triggered.

    tDate apply( tEngine& Engine, double gMultiplier ) {
        bool bValid;
        return apply( Engine, gMultiplier, 0, bValid );
    }

    tDate apply( tEngine& Engine, double gMultiplier, bool& bValid ) {
        return apply( Engine, gMultiplier, 0, bValid );
    }

    tDate apply( tEngine& Engine, double gMultiplier, double gUnitValue ) {
        bool bValid;
        return apply( Engine, gMultiplier, gUnitValue, bValid );
    }

    tDate apply( tEngine& Engine, double gMultiplier,
        double gUnitValue, bool& bValid );

    tRetCode parse( tParser& Parser, int nFlags );
    tRetCode parse( tParser& Parser );

    friend class tNumericalExpr;
};

MTG_END_NAMESPACE

#endif
