// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_DATE_FORMAT_)
#define _MTG_DATE_FORMAT_

#include "MtgDate.h"

MTG_BEGIN_NAMESPACE


//
//   t D a t e F o r m a t
//

class tDateFormat {

    char* m_sFormat;    // owned
    char* m_sBuffer;    // owned
    tDate m_Date;

    void cleanup();
    char* format() const;

public:

    tDateFormat();
    tDateFormat( const char* sFormat );
    tDateFormat( const char* sFormat, tDate Date );

    tDateFormat( const tDateFormat& Format );

    ~tDateFormat();

    tDateFormat& operator=( const tDateFormat& Format );

    const char* operator()( tDate Date );
    const char* operator()() const;
};


//
//   f u n c t i o n s
//

ostream& operator<<( ostream& Out, const tDateFormat& Format );

MTG_END_NAMESPACE

#endif
