// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_DATE_RANGE_)
#define _MTG_DATE_RANGE_

#include "MtgDateBase.h"

MTG_BEGIN_NAMESPACE


//
//   t D a t e R a n g e
//

class tDateRange : public tDateBase {

    typedef tDateBase super;

    int m_nNumOfSamples;

protected:

    void copyFrom( const tDateRange& Range );

public:

    tDateRange();
    tDateRange( tScale nScale );
    tDateRange( tScale nScale, int nNumOfPeriods );
    tDateRange( tScale nScale, const tDayCount& DayCount );
    tDateRange( tScale nScale, int nNumOfPeriods,
        const tDayCount& DayCount );
    tDateRange( tScale nScale, const tDayCount& DayCount,
        tDate Base );
    tDateRange( tScale nScale, int nNumOfPeriods,
        const tDayCount& DayCount, tDate Base );

    tDateRange( const tDateRange& Range );

    ~tDateRange();

    tDateRange& operator=( const tDateRange& Range );

        // Set the size in various ways, directly and
        // indirectly.

    void setNumOfSamples( int nNumOfSamples );
    void setNumOfSamples( tDate Maturity, bool bCovering = true );

        // Retrieve parameters individually:

    int numOfSamples() const {
        return m_nNumOfSamples;
    }

        // Get the coverage of the object as a day count fraction.
        // Substitute the base date, if desired.

    double duration() const;
    double duration( tDate Base ) const;

        // The following functions test whether a subinterval,
        // time unit or date is contained in the date range.

    bool isCoveredSI( int nSub ) const;
    bool isCoveredSI( double gSub ) const;

    bool isCoveredTU( int nUnit ) const;
    bool isCoveredTU( double gUnit ) const;

    bool isCovered( int nSub ) const {
        return isCoveredSI( nSub );
    }

    bool isCovered( double gSub ) const {
        return isCoveredSI( gSub );
    }

    bool isCovered( tDate Date ) const;
};

MTG_END_NAMESPACE

#endif
