// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_ENTROPY_OPT_)
#define _MTG_ENTROPY_OPT_

#include "MtgOptimizer.h"
#include "MtgMCOptInstance.h"
#include "MtgMinimizer.h"

MTG_BEGIN_NAMESPACE


//
//   t E n t r o p y O p t
//

class tEntropyOpt : public tOptimizer {

    typedef tOptimizer super;

        // For Monte Carlo optimization, this is the
        // optimizer instance:

    class tMCEntropyOptInstance : public tMCOptInstance, tMinimizer {

        typedef tMCOptInstance super;

        void eval( const tHeap<double>& Lambda, double& gTotal,
            tHeap<double>& Gradient );

    public:

        tMCEntropyOptInstance( const tEntropyOpt& Optimizer, 
            tMCEngine& Engine );

        ~tMCEntropyOptInstance();

        tRetCode minimize( double& gTotal );
    };

    double m_gLoBound;
    double m_gHiBound;

    void copyFrom( const tEntropyOpt& Opt );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );
    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );

public:

    tEntropyOpt();
    tEntropyOpt( const tEntropyOpt& Opt );

    ~tEntropyOpt();

    tEntropyOpt& operator=( const tEntropyOpt& Opt );

    tObject* clone() const;

    tRetCode finalize();

    tRetCode createInstance( tMCEngine* pEngine,
        tMCOptInstance*& pOpt ) const;

    friend class tMCEntropyOptInstance;
};

MTG_END_NAMESPACE

#endif
