// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_EX_POLICY_EXPR_)
#define _MTG_EX_POLICY_EXPR_

#include "MtgLookup.h"

MTG_BEGIN_NAMESPACE

class tEngine;
class tFactor;
class tNumericalExpr;
class tPortfolio;
class tParser;
class tSeqEvGenerator;
    

//
//   t E x P o l i c y E x p r
//
    
class tExPolicyExpr {

public:

    enum tType {
        xExPolicy,
        xIfThen, xIfThenElse
    };

private:

    tType m_nType;

        // Leaves of expression trees store their value here.

    tExPolicy m_nExPolicy;

        // Function and operation nodes store the pointers to their
        // subexpressions here. Unused pointers must be set to 0.

    tNumericalExpr* m_pCond;
    tExPolicyExpr *m_Child[2];

        // Some helper functions.

    void init();

        // This constructor creates an xExPolicy node.

    void setType( tType nType, tExPolicy nExPolicy );

        // This constructor creates an xIfThen node.

    void setType( tType nType, tNumericalExpr *pCond, 
        tExPolicyExpr *pChild );

        // This constructor creates an xIfThenElse node.

    void setType( tType nType, tNumericalExpr *pCond, 
        tExPolicyExpr *pChild1, tExPolicyExpr *pChild2 );

    tRetCode parseExPolicy( tParser& Parser, bool& bGo );
    tRetCode parseIfThenElse( tParser& Parser );
    tRetCode parse1( tParser& Parser );

public:

    tExPolicyExpr();
    tExPolicyExpr( tExPolicyExpr& Expr );

    ~tExPolicyExpr();

    void reset();

    tExPolicyExpr& operator=( tExPolicyExpr& Expr );

    void copyFrom( tExPolicyExpr& Expr );

    tRetCode resolve( int nThisId, tLookup<int>& Claim,
        tLookup<int>& Factor, tHeap<tFactor*>& FactorPtr, tPortfolio& Pf );        

    void getEvents( tSeqEvGenerator& EvGen ) const;
    void getBarriers( const tFactor* pFactor, tHeap<double>& Barrier ) const;

        // These functions throw an exception if something goes
        // wrong. bValid is used to determine whether the missing
        // else branch of any if..then..endif clause has been
        // triggered.

    tExPolicy apply( tEngine& Engine, double gUnitValue ) {
        bool bValid;
        return apply( Engine, gUnitValue, bValid );
    }

    tExPolicy apply( tEngine& Engine, double gUnitValue, bool& bValid );

    tRetCode parse( tParser& Parser );
};

MTG_END_NAMESPACE

#endif
