// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_EXPRESSION_)
#define _MTG_EXPRESSION_

#include "MtgLookup.h"

MTG_BEGIN_NAMESPACE

class tFactor;
class tPortfolio;
class tSeqEvGenerator;


//
//   t E x p r e s s i o n
//

class tExpression {

        // This is just a base class to provide a singular
        // base for different types of expressions, such
        // as numerical or date expressions. There is no 
        // significant code.

public:

        // Some functionalities in expressions depend on
        // flags, usually passed in a parameter nFlags.
        // Some flags are defined here, others in subclasses.

        // Allow expressions that work only under finite difference
        // schemes?

    static const int ALLOW_FD;

        // Allow expressions that work only under Monte Carlo
        // schemes?

    static const int ALLOW_MC;

        // Allow both types of expressions?

    static const int ALLOW_FDMC;

        // This is simply all bits on:

    static const int ALLOW_ALL;

public:

    tExpression() {
    }

    virtual ~tExpression() {
    }

    virtual tExpression* clone() = 0;

        // resolve references to factors and other claims:

    virtual tRetCode resolve( int nThisId, tLookup<int>& Claim,
        tLookup<int>& Factor, tHeap<tFactor*>& FactorPtr,
        tPortfolio& Pf, int nFlags ) = 0;

    virtual tRetCode resolve( int nThisId, tLookup<int>& Claim,
        tLookup<int>& Factor, tHeap<tFactor*>& FactorPtr,
        tPortfolio& Pf ) = 0;

        // find events for finite difference methods in
        // time-based comparisons:

    virtual void getEvents( tSeqEvGenerator& EvGen ) const {
    }

        // find barriers for finite difference methods  
        // in space-based comparisons:

    virtual void getBarriers( const tFactor* pFactor,
        tHeap<double>& Barrier ) const {
    }
    
        // find all top-level constants (which could be
        // barriers):

    virtual void getConstants( tHeap<double>& Constant ) const {
    }
};

MTG_END_NAMESPACE

#endif
