// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgFactor.h"
#include "MtgParser.h"

MTG_BEGIN_NAMESPACE


//
//   c o p y F r o m
//

void tFactor::copyFrom( const tFactor& Factor )

{
    if( &Factor == this )
        return;

    super::copyFrom( Factor );
}


//
//   p a r s e P a r a m
//

tRetCode tFactor::parseParam( tParser& Parser, tParseInfoStub& Info )

{
    return super::parseParam( Parser, Info );
}


//
//   t F a c t o r
//

tFactor::tFactor()

{
}


//
//   t F a c t o r
//

tFactor::tFactor( const tFactor& Factor )

{
    copyFrom( Factor );
}


//
//   ~ t F a c t o r
//

tFactor::~tFactor()

{
}


//
//   o p e r a t o r =
//

tFactor& tFactor::operator=( const tFactor& Factor )

{
    if( &Factor != this )
        copyFrom( Factor );
    return *this;
}


//
//   c l o n e
//

tObject* tFactor::clone() const

{
    return new tFactor( *this );
}


//
//   f i n a l i z e
//

tRetCode tFactor::finalize()

{
    return super::finalize();
}


//
//   p a r s e
//

tRetCode tFactor::parse( tParser& Parser, tSystem& System, tObject*& pObj )

{
    tRetCode nRet;
    tFactor* pFactor;

    if( ( nRet = Parser.scanBeginOfObj() ) != OK )
        return nRet;

    pFactor = new tFactor;
    pFactor->setSystem( System );

    if( ( nRet = pFactor->super::parse( Parser ) ) != OK ) {
        delete pFactor;
        return nRet;
    }

    pObj = pFactor;
    return OK;
}

MTG_END_NAMESPACE