// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_FACTOR_)
#define _MTG_FACTOR_

#include "MtgObject.h"

MTG_BEGIN_NAMESPACE


//
//   t F a c t o r
//

class tFactor : public tObject {

    typedef tObject super;

    void copyFrom( const tFactor& Factor );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

public:

    tFactor();
    tFactor( const tFactor& Factor );

    ~tFactor();

    tFactor& operator=( const tFactor& Factor );

    tObject* clone() const;

    tRetCode finalize();

    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );
};

MTG_END_NAMESPACE

#endif
