// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_GEO_IMPLICIT_)
#define _MTG_GEO_IMPLICIT_

#include "MtgOFImplicit.h"
#include "MtgGeoSolver.h"
#include "MtgGeoEngine.h"

MTG_BEGIN_NAMESPACE

class tGeoSpaceAxis;


//
//   t G e o I m p l i c i t
//

class tGeoImplicit : public tOFImplicit, public tGeoSolver {

    typedef tOFImplicit super;

private:

    void init();

    void calcWeights( int nFromLevel, int nToLevel,
        const tProcessParamsStub& Params );

    void adjustZeroGammaUpBoundary( int nLevel,
        tRBWeights& RBWeights, tZGWeights& ZGWeights );

    void adjustZeroGammaDownBoundary( int nLevel,
        tRBWeights& RBWeights, tZGWeights& ZGWeights );

public:

        // A tGeoImplicit object doesn't make sense without the axis.

    tGeoImplicit( tGeoSpaceAxis* pAxis );
    tGeoImplicit( const tGeoImplicit& Implicit );

    ~tGeoImplicit();

    tGeoImplicit& operator=( const tGeoImplicit& Implicit );
    void copyFrom( const tGeoImplicit& Implicit );
};

MTG_END_NAMESPACE

#endif
