// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_GEO_SOLVER_)
#define _MTG_GEO_SOLVER_

#include "MtgGeoSpaceAxis.h"
#include "MtgOFSolver.h"

MTG_BEGIN_NAMESPACE


//
//   t G e o S o l v e r
//

class tGeoSolver {

        // This class combines common variables and helper functions
        // for explicit and implicit solvers for the geometric
        // Brownian motion problem class. This class is _not_ derived
        // from tOFSolver, but meant to be used via multiple inheritance.

public:

    struct tProcessParams : public tOFSolver::tProcessParamsStub {
        double m_gVol;
        double m_gDrift;
        double m_gDiscount;     // this is the discount rate
        double m_gCCDiscount;   // this is the continuously compounded
    };                          // discount factor, basically
                                // exp( m_gDiscount )

private:

    tGeoSpaceAxis* m_pAxis;     // not owned, only referenced

    void init();

protected:

    tGeoSpaceAxis& axis() {
        return *m_pAxis;
    }

    tGeoSolver();
    void copyFrom( const tGeoSolver& Solver );

public:

    tGeoSolver( tGeoSpaceAxis* pAxis );
    tGeoSolver( const tGeoSolver& Solver );

    ~tGeoSolver();

        // Compute the _explicit_ up and down probabilities, _without_
        // discounting:

    void calcProb( int nLevel, double gVol, double gDrift,
        double gRelDuration, double& gPU, double& gPD ) const {
        m_pAxis->calcProb( nLevel, gVol, gDrift, gRelDuration, gPU, gPD );
    }

    double calcGamma( int nLevel, double gVU, double gVM, double gVD ) const {
        return m_pAxis->calcGamma( nLevel, gVU, gVM, gVD );
    }
};

MTG_END_NAMESPACE

#endif
