// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_HJMENGINE_)
#define _MTG_HJMENGINE_

#include "MtgMCEngine.h"
#include "MtgHJMTermStruct.h"

MTG_BEGIN_NAMESPACE

class tSamplePath;


//
//   t H J M E n g i n e
//

class tHJMEngine : public tMCEngine {

    typedef tMCEngine super;

    tHJMTermStruct m_TermStruct;

    void init();

    tRetCode beforeRun();
    tRetCode afterRun();

    tRetCode preparePath();

public:

    tHJMEngine();
    ~tHJMEngine();

    const tDateBase& dateBase() const;
    const tDateRange& dateRange() const;

        // The day and date forms:

    double forward( double gFromDay, double gToDay ) const;
    double forward( tDate Start, tDate End ) const;

    double presentValue( double gFromDay, double gToDay ) const;        
    double futureValue( double gFromDay, double gToDay ) const;        

    double presentValue( tDate Start, tDate End ) const;
    double futureValue( tDate Start, tDate End ) const;

    double forwardForward( double gRefDay,
        double gFromDay, double gToDay ) const;
    double forwardForward( tDate Ref,
        tDate Start, tDate End ) const;

    double discountFactor( double gRefDay,
        double gFromDay, double gToDay ) const;
    double accrualFactor( double gRefDay,
        double gFromDay, double gToDay ) const;

    double discountFactor( tDate Ref, tDate Start, tDate End ) const;
    double accrualFactor( tDate Ref, tDate Start, tDate End ) const;

        // The SI form:

    double forwardSI( double gFromSub, double gToSub ) const;

    double presentValueSI( double gFromSub, double gToSub ) const;        
    double futureValueSI( double gFromSub, double gToSub ) const;        

    double forwardForwardSI( double gRefSub,
        double gFromSub, double gToSub ) const;

    double discountFactorSI( double gRefSub,
        double gFromSub, double gToSub ) const;
    double accrualFactorSI( double gRefSub,
        double gFromSub, double gToSub ) const;
};

MTG_END_NAMESPACE

#endif
