// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_IMAGE_)
#define _MTG_IMAGE_

#include "MtgColor.h"
#include "MtgObject.h"
#include "MtgFileName.h"
#include "MtgHeap.h"

MTG_BEGIN_NAMESPACE

class tCurveContainer;
class tImageInstance;
class tPathSpace;
class tPortfolio;


//
//   t I m a g e
//

class tImage : public tObject {

    typedef tObject super;

    enum tStyle {
        xLines,
        xSteps
    };

    struct tPlot {
        tObject* m_pGraph;       // reference
        tColor m_nColor;
        tStyle m_nStyle;
    };

    struct tParseInfo : super::tParseInfoStub {
        bool m_bSize;
    };

    tHeap<tPlot> m_Plot;        // descriptions of plots
    char* m_sTitle;

    int m_nSizeX;               // size in pixels
    int m_nSizeY;               // default: 640 x 480

    bool m_bHasMinY;
    double m_gMinY;             // override min and max
    bool m_bHasMaxY;            // values on y-axis?
    double m_gMaxY;             

    bool m_bDrawHorzGrid;
    bool m_bDrawVertGrid;
    bool m_bDrawPfGrid;

    double m_gFactor;           // multiply all values by this
                                // factor (default: 100)

    tFileName m_OutFile;        // for saving the image, later

    tPortfolio* m_pPortfolio;   // referenced
    tPathSpace* m_pPathSpace;   // referenced

    void init();
    void cleanup();

    void copyFrom( const tImage& Image );

    tPlot& addPlot( tObject* pGraph );

    tRetCode parsePlot( tParser& Parser );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );
    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );

    friend class tImageInstance;

public:

    tImage();
    tImage( const tImage& Image );

    ~tImage();

    tObject* clone() const;

    tImage& operator=( const tImage& Image );

    tRetCode finalize();

        // Need to create an image instance to actually draw it:

    tRetCode createInstance( tImageInstance*& pImage );
    tRetCode createInstance( tImageInstance*& pImage,
        tCurveContainer& Container );

    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );
};

MTG_END_NAMESPACE

#endif
