// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_IMAGE_CONTAINER_)
#define _MTG_IMAGE_CONTAINER_

#include "MtgFileName.h"
#include "MtgHeap.h"

MTG_BEGIN_NAMESPACE

class tCurveContainer;
class tImage;
class tImageInstance;
class tParser;


//
//   t C u r v e C o n t a i n e r
//

class tImageContainer {

    struct tItem {
        tImage* m_pImage;               // referenced,
        tFileName m_OutFile;            // override save (optional)
        tImageInstance* m_pInstance;    // used during evaluation    
    };

    tHeap<tItem*> m_Item;               // list of references to images

    void cleanup();
    void copyFrom( const tImageContainer& Container );

    void addImage( tImage* pImage, const tFileName* pOutFile );

public:

    tImageContainer();
    tImageContainer( const tImageContainer& Container );

    ~tImageContainer();

    tImageContainer& operator=( const tImageContainer& Container );

    void merge( const tImageContainer& Container );

    bool hasImages() const {
        return m_Item.numOfElems() > 0;
    }

        // Prepare all images, while putting the curves
        // into the curve container (which needs to be
        // prepared after the images).

    tRetCode prepare( tCurveContainer& Curves );

        // Draw and save all the images after the curves
        // have been computed.

    tRetCode save() const;

    tRetCode parse( tParser& Parser );
};

MTG_END_NAMESPACE

#endif
