// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_INTEREST_CONVENTION_)
#define _MTG_INTEREST_CONVENTION_

#include "MtgObject.h"
#include "MtgInterest.h"

MTG_BEGIN_NAMESPACE


//
//   t I n t e r e s t C o n v e n t i o n
//

class tInterestConvention : public tObject {

    typedef tObject super;

    struct tParseInfo : super::tParseInfoStub {
        bool m_bDayCount;
        bool m_bQuote;
        bool m_bType;
    };

    tInterest m_Interest;

    void copyFrom( const tInterestConvention& Convention );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );
    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );

public:

    tInterestConvention();
    tInterestConvention( const tInterestConvention& Convention );

    ~tInterestConvention();

    tInterestConvention& operator=( const tInterestConvention& Convention );

    tObject* clone() const;

    tRetCode finalize();

    const tInterest& interest() const {
        return m_Interest;
    }

    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );
};

MTG_END_NAMESPACE

#endif
