// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_JOB_PIPE_)
#define _MTG_JOB_PIPE_

#if defined(_WIN32)
    #include <windows.h>
#endif

MTG_BEGIN_NAMESPACE

class tJobPool;
class tLog;


//
//   t J o b P i p e
//

class tJobPipe {

        // A job request delivered through a job pipe has
        // the following form: 
        //  
        // <group>\n
        // <start directory>\n
        // <program name>\n
        // <command line parameters>\n
        // [rest, ignored]
        //
        // where each item can be empty. The response is
        // simply the return value.

    struct tRequest {
        char* m_sGroup;
        char* m_sDir;
        char* m_sProgram;
        char* m_sCmdLine;

        char* getLine( const char*& sRequest ) const;

        tRequest( const char* sRequest );
        ~tRequest();
    };

    char* m_sName;
    bool m_bAlive;

    tJobPool* m_pJobPool;
    tLog* m_pLog;

        // The pipe is message oriented. Here are the
        // message buffers.

    char m_sRequest[2048];
    char m_sResponse[128];

#if defined(_WIN32)
    HANDLE m_hPipe;
    unsigned long m_hThread;    // we use blocking mode
    CRITICAL_SECTION m_LogLock;
#endif

    static const char* m_sStdName;

    bool lockLog();             
    void unlockLog();

    tRetCode process( const char* sRequest );

    void run();
    static void run( void* p );

        // Job pipes cannot be copied.

    tJobPipe( const tJobPipe& ) {
        throw tException( INTERNAL_ERROR );
    }

        // Job pipes must be allocated dynamically.

    ~tJobPipe();

public:

        // A job pipe must be connected to a job pool!

    tJobPipe( tJobPool* pJobPool );

    void setName( const char* sName );

    void setLog( tLog* pLog );
    void setLog( tLog& Log ) {
        setLog( &Log );
    }

    const char* name() const {
        return m_sName;
    }

    tRetCode start();

        // Use this instead of "delete":

    void die();

        // Service functions for the client side, to
        // obey the proper protocol:

    static tRetCode submit( const char* sGroup, const char* sDir,
        const char* sProgram, const char* sCmdLine );

    static tRetCode submit( const char* sCmdLine );
};

MTG_END_NAMESPACE

#endif
