// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_JOB_POOL_)
#define _MTG_JOB_POOL_

#include "MtgHeap.h"

#if defined(_WIN32)
    #include <windows.h>
#endif

MTG_BEGIN_NAMESPACE

class tLog;


//
//   t J o b P o o l
//

class tJobPool {

        // A job pool controls local processes, of which only 
        // a few can run. The emphasis is on processes that are
        // triggered through the Web and potentially run a long
        // time. A job pool cooperates with job pipes, through
        // which requests are transmitted.

    struct tJob {
        bool m_bActive;
        char* m_sGroup;             // only one job for a given group
                                    // can be active at a time
#if defined(_WIN32)
        PROCESS_INFORMATION m_Info;
#endif

        bool stillActive();
        void terminate( tLog* pLog = 0 );
    };

    tHeap<tJob> m_Job;
    int m_nRefCnt;

#if defined(_WIN32)
    CRITICAL_SECTION m_Lock;
#endif

    static const int m_nStdNumOfJobs;

    void lock();
    void unlock();

    void cleanup();

    int getSlotByGroup( const char* sGroup ) const;
    int getNonActiveSlot( bool bCheck ) const;

        // A job pool cannot be copied. It must be allocated
        // dynamically.

    tJobPool( const tJobPool& ) {
        throw tException( INTERNAL_ERROR );
    }

        // Instead of delete, call die().

    ~tJobPool();

public:

        // The constructor sets the references count to 1.

    tJobPool( int nNumOfJobs = -1 );

    void upRef();
    void downRef();
    
        // Replaces the destructor:

    void die();

    tRetCode createJob( const char* sGroup, const char* sDir,
        const char* sProgram, const char* sCmdLine, tLog* pLog = 0 );
};

MTG_END_NAMESPACE

#endif
