// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgLinTermStruct.h"

MTG_BEGIN_NAMESPACE


//
//   c a l c F w d
//

tRetCode tLinTermStruct::calcFwd( int nMaturity1, double gImp1, 
    int nMaturity2, double gImp2, double& gFwd ) const

{
    MTG_ASSERT( nMaturity1 >= 1 && nMaturity2 > nMaturity1 );

    gFwd = ( gImp2 * nMaturity2 - gImp1 * nMaturity1 ) /
            ( nMaturity2 - nMaturity1 );

    return OK;
}

MTG_END_NAMESPACE

#if defined(_TEST)

#if defined(_WIN32)
    #include <conio.h>
#endif

MTG_USING_NAMESPACE
 
//
//   m a i n
//

void main( int argc, char *argv[] )

{
    bool bGo;
    int cCmd, nRet, nMaturity, nFromUnit, nToUnit;
    double gDrift, gMin, gMax, gFromUnit, gToUnit;
    tLinTermStruct TS, TS1;

    printf( "\nTest tLinTermStruct\n\n" );

    bGo = true;
    while( bGo ) {
        printf( "<R>eset <I>mp <F>wd <G>etFwd Get<S>tat E<x>it: " );
        cCmd = getche();
        printf( "\n" );

        nRet = OK;
        switch( cCmd ) {
            case 'r' :
            case 'R' :
                TS.reset();
                break;

            case 'i' :
            case 'I' :
                printf( "  Maturity Drift: " );
                scanf( "%d%lg", &nMaturity, &gDrift );
                nRet = TS.addImplied( nMaturity, gDrift );
                break;

            case 'f' :
            case 'F' :
                printf( "  Maturity Drift: " );
                scanf( "%d%lg", &nMaturity, &gDrift );
                nRet = TS.addForward( nMaturity, gDrift );
                break;

            case 'g' :
            case 'G' :
                if( ( nRet = TS.finalize() ) == OK ) {
                    TS1 = TS;
                    printf( "  FromUnit ToUnit: " );
                    scanf( "%lg%lg", &gFromUnit, &gToUnit );
                    printf( "  Drift=%lg\n", TS1.forward( gFromUnit, gToUnit ) );
                }
                break;

            case 's' :
            case 'S' :
                if( ( nRet = TS.finalize() ) == OK ) {
                    TS.getFwdRange( gMin, gMax );
                    printf( "  Min=%lg Max=%lg\n", gMin, gMax );
                    printf( "  ConstantUntil=%d\n", TS.constantUntil() );
                }
                break;

            case 'x' :
            case 'X' :
                bGo = false;
                break;
        }

        if( nRet != OK )
            printf( "  Error=%d\n", nRet );
    }
}

#endif
