// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_LIN_TERM_STRUCT_)
#define _MTG_LIN_TERM_STRUCT_

#include "MtgTermStruct.h"

MTG_BEGIN_NAMESPACE
  

//
//   t L i n T e r m S t r u c t
//
    
class tLinTermStruct : public tTermStruct {

        // Regarding the tSpec structure: m_gFwd2 == m_gFwd always; and
        // m_gImp2 contains the sum of all forward rates up to and including
        // time unit m_nUnit. So in order to get the implied rate for unit t,
        // one has to compute
        // ( m_gImp2 + ( t - m_nUnit ) * m_gFwd2 ) / ( t + 1 ).

        // If drift data is requested beyond the maturity of the
        // term structure, the forward rate m_gFwd of the last unit of
        // the term structure is simply extended to infinity.

        // A general remark: *maturities* are counters of time units,
        // whereas *units* are indexed starting from 0. Thus, a maturity
        // value of 60 means the corresponding instrument is alive
        // during units 0..59. Variables nUnit, nFromUnit, nToUnit are
        // indexes of units, if not otherwise stated.

    tRetCode calcFwd( int nMaturity1, double gImp1,
        int nMaturity2, double gImp2, double& gFwd ) const;

public:

};

MTG_END_NAMESPACE

#endif
