// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgMCOptInstance.h"
#include "MtgMCEngine.h"
#include "MtgOptimizer.h"
#include "MtgPathSpace.h"
#include "MtgPortfolio.h"

MTG_BEGIN_NAMESPACE


//
//   t M C O p t I n s t a n c e
//

tMCOptInstance::tMCOptInstance( const tOptimizer& Optimizer, 
    tMCEngine& Engine )
    : super( Optimizer, Engine )

{
    m_pValue = 0;
}


//
//   ~ t M C O p t I n s t a n c e
//

tMCOptInstance::~tMCOptInstance()

{
}


//
//   p r e p a r e
//

tRetCode tMCOptInstance::prepare( const tHeap2<double>& Value,
    const tPortfolio& Portfolio )

{
    tRetCode nRet;

    if( ( nRet = super::prepare( Portfolio ) ) != OK )
        return nRet;

    MTG_ASSERT( m_Lambda.numOfElems() + 1 == Value.numOfCols() );

    m_pValue = &Value;
    m_Weight.numOfElems( Value.numOfRows() );

    return OK;
}


//
//   r u n
//

tRetCode tMCOptInstance::run( const tHeap2<double>& Value,
    const tPortfolio& Portfolio, double& gTotal )

{
    tRetCode nRet;

    if( ( nRet = prepare( Value, Portfolio ) ) != OK )
        return nRet;
    return run( gTotal );
}


//
//   r u n
//

tRetCode tMCOptInstance::run( double& gTotal )

{
    MTG_ASSERT( m_pValue != 0 );

    double gMin;
    tRetCode nRet;

        // the result of the minimization is not necessarily
        // the resulting price of the portfolio

    if( ( nRet = minimize( gMin ) ) != OK )
        return nRet;

        // this price is computed now:

    int n = m_pValue->numOfCols() - 1;  // number of priced instruments
    int m = m_Weight.numOfElems();      // number of paths

    gTotal = 0;

    for( int k = 0; k < m; ++k ) {
        double gSum = (*m_pValue)[k][n];

        for( int i = 0; i < n; ++i )
            gSum += (*m_pValue)[k][i] * m_Lambda[i];

        gTotal += gSum * m_Weight[k];
    }

    return OK;
}

MTG_END_NAMESPACE
