// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_NET_SERVER_)
#define _MTG_NET_SERVER_

#include "MtgHeap.h"

#if defined(_WIN32)
    #include <windows.h>
#endif

MTG_BEGIN_NAMESPACE

class tEvaluate;
class tLog;
class tSocket;
                                     

//
//   t N e t S e r v e r
//

class tNetServer {

    int m_nPort;
    tLog* m_pLog;

    static const int m_nStdPort;

    tRetCode banner( tSocket& Sock );

    tRetCode protError( tSocket& Sock, const char* sFmt, ... );
    tRetCode commError( tSocket& Sock, tRetCode nRet );

    tRetCode report( tSocket& sock, tEvaluate* pEvaluate, bool& bSayBye );

        // Server objects are unique, they cannot be copied.

    tNetServer( const tNetServer& ) {
        throw tException( INTERNAL_ERROR );
    }

public:

    tNetServer();
    ~tNetServer();

    void setLog( tLog &Log ) {
        setLog( &Log );
    }
    void setLog( tLog* pLog );

    void run( tSocket& Sock );

    tRetCode useArgs( int& argc, const char* argv[] );
        
        // This function only returns in case of error:

    tRetCode main();
};

MTG_END_NAMESPACE

#endif
