// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgNetSource.h"
#include "MtgSocket.h"

MTG_BEGIN_NAMESPACE


//
//   i n i t
//

void tNetSource::init()

{
    m_pSock = 0;
    m_bOpen = false;
    makeSafe();
}


//
//   o p e n
//

tRetCode tNetSource::open()

{
    if( m_bOpen )       // Socket is already open.
        return OK;
    return OPEN_ERROR;  // If not - error.
}


//
//   r e a d C h a r
//

tRetCode tNetSource::readChar( int& nNextChar )

{
    tRetCode nRet;

    if( ! m_bOpen ) {
        nNextChar = EOF;
    }
    else {
        char c;

        if( ( nRet = m_pSock->readChar( c ) ) != OK ) {
            if( nRet == END_OF_FILE )
                nNextChar = EOF;
            else
                return nRet;
        }
        else {
            nNextChar = c;
        }
    }
    return OK;
}


//
//   c l o s e
//

void tNetSource::close()

{
    if( m_bOpen) {
            // Don't really close the socket.
        m_pSock = 0;
        m_bOpen = false;
    }
}


//
//   t N e t S o u r c e
//

tNetSource::tNetSource()

{
    init();
}


//
//   t N e t S o u r c e
//

tNetSource::tNetSource( tSocket* pSock )

{
    init();
    setSocket( pSock );
}


//
//   t N e t S o u r c e
//

tNetSource::tNetSource( const tNetSource& Net )

{
    init();
    copyFrom( Net );
}


//
//   o p e r a t o r =
//

tNetSource& tNetSource::operator=( const tNetSource& Net )

{
    if( &Net != this )
        copyFrom( Net );
    return *this;
}


//
//   c o p y F r o m
//

void tNetSource::copyFrom( const tNetSource& Net )

{
    if( &Net == this )
        return;

    m_pSock = Net.m_pSock;
    m_bOpen = Net.m_bOpen;
}


//
//   s e t S o c k e t
//

void tNetSource::setSocket( tSocket* pSock )

{
    if( m_bOpen )
        close();
    m_pSock = pSock;
    if( m_pSock != 0 )
        m_bOpen = true;
}

MTG_END_NAMESPACE