// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_NET_SOURCE_)
#define _MTG_NET_SOURCE_

#include "MtgSource.h"

MTG_BEGIN_NAMESPACE

class tSocket;


//
//   t N e t S o u r c e
//

class tNetSource : public tSource {

    tSocket* m_pSock;
    bool m_bOpen;

    void init();

    const char* name() const {
        return "<net>";
    }

    tRetCode open();
    tRetCode readChar( int& nNextChar );
    void close();

public:

    tNetSource();
    tNetSource( tSocket* pSock );
    tNetSource( const tNetSource& Net );

    tNetSource& operator=( const tNetSource& Net );

    void copyFrom( const tNetSource& Net );

    void setSocket( tSocket* pSock );
};

MTG_END_NAMESPACE

#endif
