// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgOFExplicit.h"
#include "MtgOFEngine.h"

MTG_BEGIN_NAMESPACE


//
//   i n i t
//

void tOFExplicit::init()

{
}


//
//   t O F I m p l i c i t
//

tOFExplicit::tOFExplicit()

{
    init();
}


//
//   c o p y F r o m
//

void tOFExplicit::copyFrom( const tOFExplicit& Explicit )

{
    if( this == &Explicit )
        return;

    super::copyFrom( Explicit );
}




//
//   s o l v e
//

void tOFExplicit::solve( int nSlot )

{
    tSlot& S = slot( nSlot );

        // The explicit scheme is straightforward:

    int nLevel = -S.m_nNumOfDownLevels;
    tRBWeights* pW = &S.m_DownRBWeights;

        // Note that gLastD always exists, even at the boundary.

    double gLastD = layer().lastValue( nLevel - 1, S.m_nIndex );
    double gLastM = layer().lastValue( nLevel, S.m_nIndex );

    while( nLevel <= S.m_nNumOfUpLevels ) {
        double gLastU = layer().lastValue( nLevel + 1, S.m_nIndex );

        layer().setCurValueAndTotal( nLevel, S.m_nIndex, 
            gLastD * pW->m_gLastD +
            gLastM * pW->m_gLastM +
            gLastU * pW->m_gLastU,
            S.m_gMultiplier );

        if( ++nLevel <= S.m_nNumOfUpLevels ) {
            gLastD = gLastM;
            gLastM = gLastU;        

            if( nLevel == S.m_nNumOfUpLevels )
                pW = &S.m_UpRBWeights;
            else
                pW = &RBWeights( nLevel );
        }
    }
}


//
//   t O F E x p l i c i t
//

tOFExplicit::tOFExplicit( int nRootLevel, int nNumOfUpLevels,
    int nNumOfDownLevels )
    : super( nRootLevel, nNumOfUpLevels, nNumOfDownLevels )

{
    init();
}


//
//   t O F E x p l i c i t
//

tOFExplicit::tOFExplicit( const tOFExplicit& Explicit )

{
    init();
    copyFrom( Explicit );
}


//
//   ~ t O F E x p l i c i t
//

tOFExplicit::~tOFExplicit()

{
}


//
//   p r e p a r e
//

void tOFExplicit::prepare( tOFEngine& Engine, tSlotLayer& Layer,
     int nNumOfUpLevels, int nNumOfDownLevels,
     int nLastNumOfUpLevels, int nLastNumOfDownLevels )

{
    super::prepare( Engine, Layer, nNumOfUpLevels, nNumOfDownLevels,
        nLastNumOfUpLevels, nLastNumOfDownLevels );
}


//
//   p r e p a r e
//

void tOFExplicit::prepare( int nIndex,
    int nNumOfUpLevels, tBoundary nUpBoundary,
    int nNumOfDownLevels, tBoundary nDownBoundary )

{
        // Extrapolation has been done already; no
        // zero gamma boundary condition is needed here.        
    super::prepare( nIndex, nNumOfUpLevels, xGivenValue,
        nNumOfDownLevels, xGivenValue );
}

MTG_END_NAMESPACE