// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_OFEXPLICIT_)
#define _MTG_OFEXPLICIT_

#include "MtgOFSolver.h"

MTG_BEGIN_NAMESPACE


//
//   t O F E x p l i c i t
//

class tOFExplicit : public tOFSolver {

    typedef tOFSolver super;

private:

    void init();

protected:

    tOFExplicit();

    void copyFrom( const tOFExplicit& Explicit );

    void solve( int nSlot );

public:

    tOFExplicit( int nRootLevel, int nNumOfUpLevels,
        int nNumOfDownLevels );

    tOFExplicit( const tOFExplicit& Explicit );

    ~tOFExplicit();

    void prepare( tOFEngine& Engine, tSlotLayer& Layer,
        int nNumOfUpLevels, int nNumOfDownLevels,
        int nLastNumOfUpLevels, int nLastNumOfDownLevels );

    void prepare( int nIndex,
        int nNumOfUpLevels, tBoundary nUpBoundary,
        int nNumOfDownLevels, tBoundary nDownBoundary );
};

MTG_END_NAMESPACE

#endif
