// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_OFIMPLICIT_)
#define _MTG_OFIMPLICIT_

#include "MtgOFSolver.h"
#include "MtgHeap2.h"

MTG_BEGIN_NAMESPACE


//
//   t O F I m p l i c i t
//

class tOFImplicit : public tOFSolver {

    typedef tOFSolver super;

private:

    double m_gOmega;                // used for SOR solver
    double m_gOmegaStep;            
    double m_gErrorThreshold;
    int m_nEstIterCount;
    int m_nMaxIterCount;

    tHeap<double> m_D;              // used in the LU solver,
    tHeap<double> m_DL;             // based on LAPACK
    tHeap<double> m_DU;
    tHeap<double> m_DU2;
    tHeap<double> m_B;
    tHeap<double> m_R;
    tHeap<int> m_Pivot; 

    tHeap2<double> m_Last;          // right side of system
    tHeap2<double> m_Temp3;         // used in the SOR solver

        // some constants used in the LU solver

    static const double m_gEps;
    static const double m_gSafe1;
    static const double m_gSafe2;
    static const int m_nMaxRefineCount;

    void init();

    void extrapolate( int nSlot, bool bInitial );

        // These two work together:

    void saveCurValues();
    double calcError();

    double& last( int nLevel, int nPos ) {
        return m_Last[rootLevel() + nLevel][nPos];
    }

    double& temp3( int nLevel, int nSlot ) {
        return m_Temp3[rootLevel() + nLevel][nSlot];
    }

protected:

    tOFImplicit();

    void copyFrom( const tOFImplicit& Implicit );

    void solve( int nSlot );

public:

    tOFImplicit( int nRootLevel, int nNumOfUpLevels,
        int nNumOfDownLevels );

    tOFImplicit( const tOFImplicit& Implicit );

    ~tOFImplicit();

    void prepare( tOFEngine& Engine, tSlotLayer& Layer,
        int nNumOfUpLevels, int nNumOfDownLevels,
        int nLastNumOfUpLevels, int nLastNumOfDownLevels );

    void prepare( int nIndex,
        int nNumOfUpLevels, tBoundary nUpBoundary,
        int nNumOfDownLevels, tBoundary nDownBoundary );

    tRetCode refine( tIncrement& Incr );
};

MTG_END_NAMESPACE

#endif
