// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgOptInstance.h"
#include "MtgPortfolio.h"

MTG_BEGIN_NAMESPACE


//
//   p r e p a r e
//

tRetCode tOptInstance::prepare( const tPortfolio& Portfolio )

{
    m_pPortfolio = &Portfolio;

        // Get prices and lambdas. The lambdas may be 
        // overridden before optimization by the optimizer.

    tHeap<double> Temp;

    Portfolio.getMultipliers( Temp );
    Portfolio.copyPricedIndex2Abs( Temp, m_Lambda );

    Portfolio.getPrices( Temp );
    Portfolio.copyPricedIndex2Abs( Temp, m_Price );

    m_Gradient.numOfElems( m_Price.numOfElems() );

    return OK;
}


//
//   t O p t I n s t a n c e
//

tOptInstance::tOptInstance( const tOptimizer& Optimizer, tEngine& Engine )
    : m_Optimizer( Optimizer ), m_Engine( Engine )

{
    m_pPortfolio = 0;
}


//
//   ~ t O p t I n s t a n c e
//

tOptInstance::~tOptInstance()

{
}


//
//   i n j e c t M u l t i p l i e r s
//

void tOptInstance::injectMultipliers( const tHeap<double>& Multiplier )

{
    MTG_ASSERT( m_pPortfolio != 0 );
    m_pPortfolio->copyPricedIndex2Abs( Multiplier, m_Lambda );
}


//
//   e x t r a c t M u l t i p l i e r s
//

void tOptInstance::extractMultipliers( tHeap<double>& Multiplier ) const

{
    MTG_ASSERT( m_pPortfolio != 0 );
    m_pPortfolio->copyPricedAbs2Index( m_Lambda, Multiplier );
}


//
//   e x t r a c t G r a d i e n t
//

void tOptInstance::extractGradient( tHeap<double>& Gradient ) const

{
    MTG_ASSERT( m_pPortfolio != 0 );
    m_pPortfolio->copyPricedAbs2Index( m_Gradient, Gradient );
}

MTG_END_NAMESPACE

